<?php
/**
 * Kalium WordPress Theme
 *
 * Archive page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Theme header.
 */
get_header();

/**
 * Before archive content.
 *
 * @hooked kalium_blog_archive_wrapper_start - 10
 */
do_action( 'kalium_blog_archive_before_content' );

/**
 * Archive content.
 *
 * @hooked kalium_content_wrapper_main_content_start - 0
 * @hooked kalium_blog_loop_before - 10
 * @hooked kalium_blog_posts_loop - 20
 * @hooked kalium_blog_archive_posts_pagination - 30
 * @hooked kalium_blog_loop_after - 40
 * @hooked kalium_content_wrapper_main_content_end - 999
 */
do_action( 'kalium_blog_archive_content' );

/**
 * After archive content.
 *
 * @hooked kalium_blog_sidebar_loop - 10
 * @hooked kalium_blog_archive_wrapper_end - 100
 * @hooked kalium_blog_reset_options - 1000
 */
do_action( 'kalium_blog_archive_after_content' );

/**
 * Theme footer.
 */
get_footer();
