<?php

/**
 * Kalium WordPress Theme – Creative Theme for Professionals
 *
 * @version 4.4.3
 * @author  Laborator
 * @link    https://kaliumtheme.com
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
    // Direct access not allowed.
}
/**
 * Kalium init.
 *
 * @see Kalium
 */
require_once __DIR__ . '/includes/framework/kalium.php';
/**
 * Freemius integration.
 */
if ( !function_exists( 'kalium_fs' ) ) {
    // Create a helper function for easy SDK access.
    function kalium_fs() {
        global $kalium_fs;
        if ( !isset( $kalium_fs ) ) {
            $kalium_fs = fs_dynamic_init( [
                'id'               => '15950',
                'slug'             => 'kalium-theme',
                'premium_slug'     => 'kalium',
                'type'             => 'theme',
                'public_key'       => 'pk_60e1a625a78ce39f95286ff0d47eb',
                'is_premium'       => true,
                'is_premium_only'  => true,
                'has_addons'       => false,
                'has_paid_plans'   => true,
                'is_org_compliant' => false,
                'trial'            => [
                    'days'               => 7,
                    'is_require_payment' => true,
                ],
                'has_affiliation'  => 'selected',
                'menu'             => [
                    'slug'        => 'kalium',
                    'first-path'  => 'admin.php?page=kalium&welcome',
                    'contact'     => false,
                    'support'     => false,
                    'affiliation' => false,
                ],
                'is_live'          => true,
            ] );
        }
        return $kalium_fs;
    }

    // Init Freemius.
    kalium_fs();
    // Signal that SDK was initiated.
    do_action( 'kalium_fs_loaded' );
}
/**
 * Note: Adding custom code here will be overwritten when you update the theme.
 * To safely preserve your custom code, install and activate the Kalium Child theme.
 *
 * For more details, refer to our documentation:
 * https://docs.kaliumtheme.com/getting-started/installation/child-theme
 */