<?php
/**
 * Kalium WordPress Theme
 *
 * Theme header.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
?><!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php
// WP body open
wp_body_open();

/**
 * Before wrapper hooks.
 *
 * @hooked kalium_site_frame - 10
 * @hooked kalium_mobile_menu_default_template - 20
 * @hooked kalium_header_off_canvas_top_menu_default_template - 30
 * @hooked kalium_header_off_canvas_side_menu_default_template - 40
 */
do_action( 'kalium_before_wrapper' );

/**
 * Wrapper start hooks.
 *
 * @hooked kalium_site_wrapper_start - 0
 * @hooked kalium_header_default_template - 10
 * @hooked kalium_page_heading_default_template - 20
 */
do_action( 'kalium_wrapper_start' );
