<?php
/**
 * Kalium WordPress Theme
 *
 * What's new page.
 *
 * @var array $whats_new
 * @var array $changelog
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<?php if ( ! empty( $whats_new ) ) : ?>
	<div class="row">
		<?php
		$defined_columns = [
			6 => 'col-12 col-md-6',
			4 => 'col-12 col-md-4',
			3 => 'col-12 col-md-4 col-lg-3',
			1 => 'col-12',
		];

		foreach ( $whats_new as $entry ) :
			$aspect_ratio = isset( $entry['aspect_ratio'] ) ? str_replace( ':', '-', "aspect-ratio-{$entry['aspect_ratio']}" ) : '';

			$image = kalium_render_element(
				[
					'tag_name'   => 'img',
					'attributes' => [
						'class'   => [
							$aspect_ratio,
						],
						'src'     => kalium()->assets_url( 'admin/images/whats-new/' . $entry['image'] ),
						'width'   => 300,
						'height'  => 300,
						'loading' => 'lazy',
						'alt'     => esc_attr( sanitize_title( $entry['title'] ) ),
					],
				],
				false
			);

			if ( ! empty( $entry['video'] ) && str_contains( $entry['video'], 'youtube.com' ) ) {
				$image .= sprintf( '<a href="%s" target="_blank" class="replay-video">View Video</a>', esc_attr( $entry['video'] ) );
			} elseif ( ! empty( $entry['video'] ) ) {
				$image = kalium_render_element(
					[
						'tag_name'   => 'video',
						'attributes' => [
							'class'       => [
								$aspect_ratio,
							],
							'controls'    => false,
							'preload'     => 'metadata',
							'playsinline' => true,
							'muted'       => true,
						],
						'content'    => sprintf( '<source src="%s" type="video/mp4">', $entry['video'] ),
					],
					false
				);

				$image .= '<button type="button" class="replay-video">Replay</button>';
			}

			$columns = $defined_columns[ $entry['columns'] ?? 4 ];

			$columns_classes = [
				'd-flex',
				'col',
				$columns,
			];

			$card_classes = [
				'kalium-dashboard__card',
				'kalium-dashboard__whats-new',
			];

			if ( ! empty( $entry['alternate'] ) ) {
				$card_classes[] = 'kalium-dashboard__whats-new--alternate';
			}


			?>
			<div <?php kalium_class_attr( $columns_classes ); ?>>
				<div <?php kalium_class_attr( $card_classes ); ?>>
					<figure><?php echo $image; ?></figure>
					<div class="kalium-dashboard__whats-new-details">
						<h4><?php echo esc_html( $entry['title'] ); ?></h4>
						<?php echo wpautop( nl2br( $entry['description'] ) ); ?>
					</div>
				</div>
			</div>
			<?php
		endforeach;
		?>
	</div>

	<div class="row">
		<div class="col text-center">
			<a href="https://kaliumtheme.com/whats-new-in-kalium-4/?utm_source=kalium_changelog&utm_medium=whats_new&utm_campaign=button" target="_blank" rel="noopener noreferrer" class="button button-primary see-whats-new">See all new features &rarr;</a>
		</div>
	</div>
<?php endif; ?>

<?php
// Show changelog
if ( ! empty( $changelog ) ) :

	// Changelog date format
	$date_format = 'F d, Y';
	?>
	<a id="changelog"></a>

	<?php
	foreach ( $changelog as $changelog_entry ) :
		if ( ! kalium_get_array_key( $changelog_entry, 'expand' ) ) {
			continue;
		}

		?>
		<div class="kalium-dashboard__card kalium-dashboard__card--standard">
			<h4 class="kalium-dashboard__card__header">
				<?php printf( 'Changelog &ndash; Version %s', esc_html( $changelog_entry['version'] ) ); ?>
				<small><?php echo esc_html( date_i18n( $date_format, strtotime( $changelog_entry['date'] ) ) ); ?></small>
			</h4>

			<div class="kalium-dashboard__card__content">
				<?php
				// Change type
				foreach ( $changelog_entry['changes'] as $type => $changes ) {
					if ( empty( $changes ) ) {
						continue;
					}

					?>
					<div class="kalium-dashboard__changelog">
						<div class="kalium-dashboard__changelog__badge kalium-dashboard__changelog__badge--<?php echo sanitize_title( $type ); ?>"><?php echo esc_html( $type ); ?></div>
						<ul>
							<?php foreach ( $changes as $title ) : ?>
								<li><?php echo links_add_target( make_clickable( esc_html( $title ) ) ); ?></li>
							<?php endforeach; ?>
						</ul>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	<?php endforeach; ?>

	<div class="kalium-dashboard__changelog-more">
		<a href="https://kaliumtheme.com/changelog/" class="button button-secondary" target="_blank" rel="noreferrer noopener">
			More Changelogs
			<i class="kalium-admin-icon-arrow-right"></i>
		</a>
	</div>

	<?php
endif;
