<?php
/**
 * Kalium WordPress Theme
 *
 * Kalium dashboard.
 *
 * @var bool $welcome
 * @var array $quick_links
 * @var array $integrations
 * @var bool $latest_version
 * @var bool $is_latest_version
 * @var string $update_core_link
 * @var array $license_data
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
use Kalium\Admin\Dashboard;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/*
// Welcome message
if ( $welcome ) :
	$next_steps = [];

	// Plugins
	$next_steps[] = [
		'title'       => 'Plugins',
		'description' => 'Install and activate theme recommended plugins.',
		'link'        => Dashboard::tab_link( 'plugins' ),
	];

	// Starter sites
	$next_steps[] = [
		'title'       => 'Starter Sites',
		'description' => 'Optionally, choose a starter site to import.',
		'link'        => Dashboard::tab_link( 'starter-sites' ),
	];

	// Done
	$next_steps[] = [
		'title'       => 'Done!',
		'description' => 'You’re all set, you view the site live and customize it!',
		'icon'        => 'kalium-admin-icon-check',
	];
	?>
	<div class="kalium-dashboard__card kalium-dashboard__card--standard">
		<h4 class="kalium-dashboard__card__header">
			Theme Setup Wizard
			<small>You are almost done, here are the next steps you can take to full set up the theme.</small>
		</h4>
		<div class="kalium-dashboard__card__content pv-5">
			<div class="row">
				<div class="col">
					<div class="kalium-dashboard__next-steps">
						<?php
						foreach ( $next_steps as $i => $step ) {
							$icon  = isset( $step['icon'] ) ? sprintf( '<i class="%s"></i>', $step['icon'] ) : esc_html( $i + 1 );
							$title = $step['title'];
							$title = '<strong>' . esc_html( $title ) . '</strong>';

							if ( ! empty( $step['link'] ) ) {
								$title = '<a href="' . esc_url( $step['link'] ) . '" target="_blank" rel="noopener noreferrer">' . $title . '</a>';
							}
							?>
							<div class="kalium-dashboard__next-steps__step">
								<div class="icon"><?php echo $icon; ?></div>
								<div class="content">
									<strong><?php echo $title; ?></strong>
									<?php echo esc_html( $step['description'] ); ?>
								</div>
							</div>
							<?php
						}
						?>
					</div>
				</div>
				<div class="col-lg-5">
					<div class="kalium-dashboard__theme-overview">
						<svg width="438" height="244" viewBox="0 0 438 244" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
							<g clip-path="url(#clip0_152_24031)">
								<rect width="438" height="244" rx="8" fill="url(#pattern0_152_24031)"/>
								<rect y="128" width="438" height="116" fill="url(#paint0_linear_152_24031)"/>
								<rect width="438" height="244" fill="black" fill-opacity="0.1"/>
								<rect opacity="0.3" x="40" y="220" width="378" height="8" rx="4" fill="white"/>
								<rect opacity="0.5" x="40" y="220" width="61.6541" height="8" rx="4" fill="white"/>
								<path d="M14.2 218.863C14.2 217.612 15.5725 216.845 16.6386 217.501L24.9857 222.637C26.0009 223.262 26.0009 224.738 24.9857 225.363L16.6386 230.499C15.5725 231.155 14.2 230.388 14.2 229.137V218.863Z" fill="white"/>
								<g filter="url(#filter0_b_152_24031)">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M219 154C236.673 154 251 139.673 251 122C251 104.327 236.673 90 219 90C201.327 90 187 104.327 187 122C187 139.673 201.327 154 219 154ZM214 133.738L232 123.677C233.333 122.932 233.333 121.068 232 120.323L214 110.262C212.667 109.517 211 110.449 211 111.939V132.061C211 133.551 212.667 134.483 214 133.738Z" fill="white" fill-opacity="0.3"/>
								</g>
							</g>
							<defs>
								<pattern id="pattern0_152_24031" patternContentUnits="objectBoundingBox" width="1" height="1">
									<use xlink:href="#image0_152_24031" transform="matrix(0.0005 0 0 0.000897541 0 -0.397541)"/>
								</pattern>
								<filter id="filter0_b_152_24031" x="171" y="74" width="96" height="96" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
									<feFlood flood-opacity="0" result="BackgroundImageFix"/>
									<feGaussianBlur in="BackgroundImageFix" stdDeviation="8"/>
									<feComposite in2="SourceAlpha" operator="in" result="effect1_backgroundBlur_152_24031"/>
									<feBlend mode="normal" in="SourceGraphic" in2="effect1_backgroundBlur_152_24031" result="shape"/>
								</filter>
								<linearGradient id="paint0_linear_152_24031" x1="219" y1="128" x2="219" y2="244" gradientUnits="userSpaceOnUse">
									<stop stop-opacity="0"/>
									<stop offset="1" stop-opacity="0.2"/>
								</linearGradient>
								<clipPath id="clip0_152_24031">
									<rect width="438" height="244" rx="8" fill="white"/>
								</clipPath>
								<image id="image0_152_24031" width="2000" height="2000" xlink:href="data:image/jpeg;base64,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"/>
							</defs>
						</svg>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
endif */
?>

<div class="row">
	<div class="col">
		<div class="kalium-dashboard__card kalium-dashboard__card--standard">
			<h4 class="kalium-dashboard__card__header">
				Quick Links
				<small>Speed up your site-building process with these direct links to the customizer.</small>
			</h4>
			<div class="kalium-dashboard__card__content">
				<div class="kalium-dashboard__quick-links row row-cols-1 row-cols-md-2 row-cols-lg-3">
					<?php
					foreach ( $quick_links as $quick_link ) {
						if ( isset( $quick_link['visible'] ) && false === $quick_link['visible'] ) {
							continue;
						}

						?>
						<div class="col">
							<a href="<?php echo esc_url( $quick_link['link'] ); ?>" target="_blank">
								<strong><?php echo esc_html( $quick_link['title'] ); ?></strong>
								<?php
								if ( ! empty( $quick_link['description'] ) ) {
									echo esc_html( $quick_link['description'] );
								}
								?>
							</a>
						</div>
						<?php
					}
					?>
				</div>
			</div>
		</div>
	</div>
	<div class="col-xl-4">
		<?php if ( Dashboard::maybe_show_section( 'dashboard-theme-info' ) ) : ?>
			<div class="kalium-dashboard__card kalium-dashboard__card--standard p-3">
				<?php if ( $is_latest_version ) : ?>
				<div class="kalium-dashboard__status kalium-dashboard__status--success">
					<div class="kalium-dashboard__status__icon">
						<i class="kalium-admin-icon-check-circle-broken"></i>
					</div>
					<div class="kalium-dashboard__status__content">
						<strong><?php echo esc_html( kalium_get_name() ); ?> is up to date!</strong>
						<span>You are using the latest version!</span>
					</div>
				</div>
				<?php else : ?>
					<div class="kalium-dashboard__status kalium-dashboard__status--warning">
						<div class="kalium-dashboard__status__icon">
							<i class="kalium-admin-icon-refresh"></i>
						</div>
						<div class="kalium-dashboard__status__content">
							<strong><a href="<?php echo esc_url( $update_core_link ); ?>">New update available</a></strong>
							<span>You are using an outdated version!</span>
						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="kalium-dashboard__card kalium-dashboard__card--standard">
				<h4 class="kalium-dashboard__card__header">System Status</h4>
				<div class="kalium-dashboard__card__content vsv-4" id="kalium-system-status-widget">
					<span class="text-muted">Loading system status...</span>
				</div>
			</div>
			<div class="kalium-dashboard__card kalium-dashboard__card--standard">
			<h4 class="kalium-dashboard__card__header">Theme License</h4>
			<div class="kalium-dashboard__card__content vsv-0">
				<ul class="kalium-dashboard__license-info">
					<li>
						<span>Plan:</span>
						<strong><?php echo esc_html( $license_data['plan'] ); ?></strong>
					</li>
					<li>
						<span>Subscription Term:</span>
						<strong><?php echo esc_html( $license_data['subscription_term'] ); ?></strong>
					</li>
					<?php if ( false === kalium()->license->is_lifetime() && false === kalium()->license->is_trial() ) : ?>
					<li>
						<span>Subscription Expiration:</span>
						<strong class="expiration">
							<?php echo wp_date( get_option( 'date_format' ), $license_data['expiration'] ); ?>
							<span class="badge badge-<?php echo esc_attr( kalium()->license->get_badge_class() ); ?>"><?php echo esc_html( kalium()->license->get_status_title() ); ?></span>
						</strong>

						<?php if ( kalium()->license->is_expired() ) : ?>
							<a href="<?php echo esc_url( kalium()->freemius->checkout_url() ); ?>" class="button button-renew" target="_blank" rel="noreferrer noopener"><?php echo esc_html( 'Renew &rarr;' ); ?></a>
						<?php endif; ?>
					</li>
					<?php endif; ?>
					<li>
						<span>License Key:</span>
						<pre><?php echo esc_html( $license_data['secret_key_masked'] ); ?></pre>
					</li>
					<?php if ( false === kalium()->license->is_white_labeled() ) : ?>
					<li>
						<span>Owner:</span>
						<strong><?php echo esc_html( $license_data['name'] ); ?></strong>
					</li>
					<li>
						<span>Email:</span>
						<strong><?php echo esc_html( $license_data['email'] ); ?></strong>
					</li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
		<?php endif; ?>
	</div>
</div>

<?php if ( Dashboard::maybe_show_section( 'dashboard-theme-links' ) ) : ?>
	<div class="row row-cols-1 row-cols-lg-3 row-cols-xl-4">
		<div class="col">
			<div class="kalium-dashboard__card kalium-dashboard__card--standard">
				<h4 class="kalium-dashboard__card__header kalium-dashboard__card__header--icon">
					<i class="kalium-admin-icon-feature-request"></i>
					Feature Request
				</h4>
				<div class="kalium-dashboard__card__content">
					<p>Have an idea to make Kalium even better? Share your feature suggestion with us!</p>
					<a href="https://kaliumtheme.com/go/kalium-feature-request" class="button button-external" target="_blank">Suggest a Feature</a>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="kalium-dashboard__card kalium-dashboard__card--standard">
				<h4 class="kalium-dashboard__card__header kalium-dashboard__card__header--icon">
					<i class="kalium-admin-icon-community"></i>
					Community
				</h4>
				<div class="kalium-dashboard__card__content">
					<p>Join our community to share ideas, seek help, and discuss your next Kalium project.</p>
					<a href="https://kaliumtheme.com/go/kalium-community" target="_blank" rel="noopener noreferrer" class="button button-external">Join Facebook Group</a>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="kalium-dashboard__card kalium-dashboard__card--standard">
				<h4 class="kalium-dashboard__card__header kalium-dashboard__card__header--icon">
					<i class="kalium-admin-icon-documentation"></i>
					Documentation
				</h4>
				<div class="kalium-dashboard__card__content">
					<p>Get step-by-step instructions and insider tips to unlock the full power of Kalium’s capabilities.</p>
					<a href="https://kaliumtheme.com/go/kalium-documentation" class="button button-external" target="_blank">Read Documentation</a>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="kalium-dashboard__card kalium-dashboard__card--standard">
				<h4 class="kalium-dashboard__card__header kalium-dashboard__card__header--icon">
					<i class="kalium-admin-icon-help"></i>
					Customer Support
				</h4>
				<div class="kalium-dashboard__card__content">
					<p>Questions not answered by our documentation or tutorials? Reach out to us for assistance.</p>
					<a href="https://kaliumtheme.com/go/kalium-support" class="button button-external" target="_blank" rel="noreferrer noopener">Submit a Ticket</a>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>

<?php /*
?>
<div class="kalium-dashboard__card kalium-dashboard__card--standard">
	<h4 class="kalium-dashboard__card__header">
		Integrations
		<small>Discover plugins that integrate seamlessly with the Kalium theme.</small>
	</h4>
	<div class="kalium-dashboard__card__content vsv-3">
		<div class="kalium-dashboard__integrations row row-cols-1 row-cols-lg-2 row-cols-xl-3">
			<?php
			foreach ( $integrations as $integration ) :
				?>
				<div class="col">
					<div class="kalium-dashboard__card-alt p-4">
						<i><?php echo $integration['icon']; ?></i>
						<h4 class="kalium-dashboard__card-alt__title"><?php echo esc_html( $integration['title'] ); ?></h4>
						<div class="kalium-dashboard__card-alt__content">
							<?php echo wpautop( $integration['description'] ); ?>

							<?php if ( $integration['link'] ) : ?>
							<a href="<?php echo esc_url( $integration['link'] ); ?>" target="_blank" rel="noopener noreferrer" class="external-link">
								View Integration
								<i class="kalium-admin-icon-arrow-right"></i>
							</a>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php
			endforeach;
			?>
		</div>
	</div>
</div>
<?php */ ?>
