<?php
/**
 * Kalium WordPress Theme
 *
 * Theme settings.
 *
 * @var array $settings_sections
 * @var string $active_section
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

?>
<div class="kalium-dashboard__settings kalium-dashboard__card">
	<ul class="kalium-dashboard__settings__tabs">
		<?php
		foreach ( $settings_sections as $settings_section ) {
			$classes = [
				'kalium-dashboard__settings__tabs__tab',
			];

			if ( $active_section === $settings_section['id'] ) {
				$classes[] = 'kalium-dashboard__settings__tabs__tab--active';
			}

			$link = add_query_arg( 'section', $settings_section['id'] );

			?>
			<li <?php kalium_class_attr( $classes ); ?> data-tab-id="<?php echo esc_attr( $settings_section['id'] ); ?>">
				<a href="<?php echo esc_attr( $link ); ?>">
					<i class="<?php echo esc_attr( $settings_section['icon'] ); ?>"></i>
					<?php echo esc_html( $settings_section['title'] ); ?>
				</a>
			</li>
			<?php
		}
		?>
	</ul>
	<div class="kalium-dashboard__settings__content">
		<?php
		foreach ( $settings_sections as $settings_section ) {
			$classes = [
				'kalium-dashboard__settings__section',
			];

			// Active
			if ( $active_section === $settings_section['id'] ) {
				$classes[] = 'kalium-dashboard__settings__section--active';
			}

			// Wrapper start
			printf( '<div class="%s" data-section-id="%s">', kalium_tokenize_list( $classes ), esc_attr( $settings_section['id'] ) );

			/**
			 * Setting tab hook.
			 *
			 * @param array $settings_section
			 */
			do_action( 'kalium_settings_section_' . $settings_section['id'], $settings_section );

			// Wrapper end
			echo '</div>';
		}
		?>
	</div>
</div>
