<?php
/**
 * Kalium WordPress Theme
 *
 * Starter sites page.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */

use Kalium\Admin\Dashboard;
use Kalium\Importer\Importer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}
?>
<div class="kalium-sites__top-bar">
	<div class="kalium-sites__top-bar__content">
		<a href="<?php echo esc_url( Dashboard::tab_link( 'system-status' ) ); ?>" class="button">Check your System Status</a>
		<a href="https://docs.kaliumtheme.com/getting-started/installation/importing-a-starter-site" target="_blank" rel="noreferrer noopener" class="button button-primary">Read more</a>
	</div>
	<div class="kalium-sites__top-bar__content--right">
		<div class="kalium-sites__toggle-group">
			<button class="button button-primary" title="<?php echo esc_attr( Importer::instance()->count_content_packs() . ' starter sites' ); ?>"><?php echo esc_html( 'All' ); ?></button>
			<?php foreach ( Importer::instance()->get_builder_types() as $type => $title ) : ?>
				<?php $count = Importer::instance()->count_content_packs( $type ); ?>
				<button class="button" title="<?php echo esc_attr( $count . ' starter sites' ); ?>" data-builder-type="<?php echo esc_attr( $type ); ?>"><?php echo esc_html( $title ); ?></button>
			<?php endforeach; ?>
		</div>
	</div>
</div>
<?php
/**
 * Starter sites
 */
Importer::instance()->list_starter_sites();
