<?php
/**
 * Blog posts block.
 *
 * @var WP_Block $block
 * @var array $attributes
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Build blog options
$blog_options = [

	// Layout
	'layout' => $attributes['layoutType'],

	// Loop
	'loop'   => [

		// Thumbnails
		'post_thumbnail'      => [

			// Visibility
			'visible'     => $attributes['featuredImage'],

			// Hover layer
			'hover'       => [
				// Visibility
				'visible' => $attributes['hoverEffect'],
			],

			// Placeholder
			'placeholder' => [
				'enabled' => $attributes['imagePlaceholder'],
			],

			// Boundless
			'boundless'   => $attributes['imageBoundless'],
		],

		// Title
		'post_title'          => $attributes['postTitle'],

		// Excerpt
		'post_excerpt'        => $attributes['postExcerpt'],

		// Excerpt length
		'post_excerpt_length' => $attributes['excerptMaxWords'],

		// Post meta
		'post_meta'           => [
			'visible'       => $attributes['postMeta'],
			'icon'          => $attributes['metaIcon'],
			'post_date'     => $attributes['metaDate'],
			'post_category' => $attributes['metaCategory'],
		],

		// Post formats
		'post_formats'        => $attributes['postFormatContent'],

		// Post format icon
		'post_format_icon'    => $attributes['postFormatIcon'],

		// Columns
		'columns'             => array_merge(
			kalium_get_theme_option( 'blog_grid_columns' ),
			array_filter(
				[
					'desktop' => kalium_get_array_key( $attributes, 'columns' ),
					'tablet'  => kalium_get_array_key( $attributes, 'columnsTablet' ),
					'mobile'  => kalium_get_array_key( $attributes, 'columnsMobile' ),
				],
				'is_numeric'
			)
		),

		// Gap
		'gap'                 => array_merge(
			kalium_get_theme_option( 'blog_grid_columns_gap' ) ?? [],
			array_filter(
				[
					'desktop' => kalium_get_array_key( $attributes, 'gap' ),
					'tablet'  => kalium_get_array_key( $attributes, 'gapTablet' ),
					'mobile'  => kalium_get_array_key( $attributes, 'gapMobile' ),
				],
				'is_numeric'
			)
		),

		// Masonry mode
		'masonry_mode'        => $attributes['masonryMode'],
	],
];

// Image size
$image_size = $attributes['imageSize'];

if ( 'custom' === $image_size && ! empty( $attributes['imageSizeCustom'] ) ) {
	$image_size = kalium_list_dimensions( $attributes['imageSizeCustom'] ?? null );
}

$blog_options['loop']['post_thumbnail']['size'] = $image_size;

// Aspect ratio
$aspect_ratio = $attributes['aspectRatio'];

if ( 'custom' === $aspect_ratio && ! empty( $attributes['aspectRatioCustom'] ) ) {
	$aspect_ratio = implode( '/', kalium_list_dimensions( $attributes['aspectRatioCustom'] ) ?? [] );
}

if ( 'auto' !== $aspect_ratio ) {
	$blog_options['loop']['post_thumbnail']['aspect_ratio'] = $aspect_ratio;
}

// Build query args
$query_args = kalium_build_wp_query_vars( $attributes['query'] );

// Instance ID
if ( ! isset( $GLOBALS['kalium_blog_posts_block_instance_id'] ) ) {
	$GLOBALS['kalium_blog_posts_block_instance_id'] = 0;
}

$instance_id = ++$GLOBALS['kalium_blog_posts_block_instance_id'];

// Card colors
$card_background_color = kalium_get_color_object_by_attribute_values( $attributes['cardBackgroundColor'] ?? null, $attributes['customCardBackgroundColor'] ?? null );
$card_title_color      = kalium_get_color_object_by_attribute_values( $attributes['cardTitleColor'] ?? null, $attributes['customCardTitleColor'] ?? null );
$card_text_color       = kalium_get_color_object_by_attribute_values( $attributes['cardTextColor'] ?? null, $attributes['customCardTextColor'] ?? null );

// Card border
$card_border = $attributes['cardBorder'] ?? null;

if ( is_array( $card_border ) ) {
	$card_border = wp_parse_args(
		$attributes['cardBorder'] ?? null,
		[
			'color' => null,
			'style' => 'solid',
			'width' => '0px',
		]
	);
	
	if ( ! empty( $card_border['color'] ) ) {
		$card_border['color'] = kalium_get_color_object_by_attribute_values( $card_border['color'] );
	}
}

// Card border radius
$card_border_radius = $attributes['cardBorderRadius'] ?? null;

if ( is_array( $card_border_radius ) ) {
	$card_border_radius = implode(
		' ',
		array_map(
			static function ( $value ) {
				return is_numeric( $value ) ? $value . 'px' : $value;
			},
			wp_parse_args(
				$card_border_radius,
				[
					'topLeft'     => 0,
					'topRight'    => 0,
					'bottomRight' => 0,
					'bottomLeft'  => 0,
				]
			)
		)
	);
}

// Card padding
$card_padding = $attributes['cardPadding'] ?? null;

if ( ! empty( $card_padding ) ) {
	$card_padding = implode(
		' ',
		array_map(
			static function ( $value ) {
				return is_numeric( $value ) ? $value . 'px' : $value;
			},
			$attributes['cardPadding']
		)
	);
}

// Card box shadow
$card_box_shadow = $attributes['cardBoxShadow'] ?? null;

if ( is_array( $card_box_shadow ) ) {
	$card_box_shadow = array_map(
		static function ( $value ) {
				return is_numeric( $value ) ? $value . 'px' : $value;
		},
		wp_parse_args(
			$card_box_shadow,
			[
				'color'  => null,
				'x'      => '0px',
				'y'      => '0px',
				'blur'   => '0px',
				'spread' => '0px',
			]
		)
	);

	if ( ! empty( $card_box_shadow['color'] ) ) {
		$card_box_shadow['color'] = kalium_get_color_object_by_attribute_values( $card_box_shadow['color'] );

		$card_box_shadow = implode( ' ', $card_box_shadow );
	} else {
		$card_box_shadow = null;
	}
}

// Print styles
kalium_print_inline_style(
	[
		'selector' => '#blog-posts-block-' . $instance_id,
		'vars'     => [
			'post-item-bg'            => $card_background_color,
			'post-item-title'         => $card_title_color,
			'post-item-text'          => $card_text_color,
			'post-item-border-color'  => $card_border['color'] ?? null,
			'post-item-border-style'  => $card_border['style'] ?? null,
			'post-item-border-width'  => $card_border['width'] ?? null,
			'post-item-border-radius' => $card_border_radius,
			'post-item-padding'       => $card_padding,
			'post-item-box-shadow'    => $card_box_shadow,
		],
	]
);

// Initialize blog options
kalium_init_blog_options( 'block-' . $instance_id, $blog_options );

// Start output
echo '<div ' . get_block_wrapper_attributes() . '>';

// Execute query using query_posts to set global $wp_query
query_posts( $query_args );

// Loop before
kalium_blog_loop_before();

// Posts loop
kalium_blog_posts_loop();

// Loop after
kalium_blog_loop_after();

// Reset post data
wp_reset_postdata();
wp_reset_query();

echo '</div>';
