<?php
/**
 * Portfolio items block.
 *
 * @var WP_Block $block
 * @var array $attributes
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Portfolio is not enabled
if ( ! kalium()->portfolio->is_enabled() ) {
	return;
}

// Custom loop options
$custom_loop_options = [
	'url' => get_permalink( get_queried_object() ),
];

// Set query vars
$custom_loop_options['query_vars'] = kalium_build_wp_query_vars( $attributes['query'] ?? [] );

// Query
$custom_loop_options['query'] = new \WP_Query(
	kalium_get_portfolio_loop_query_args(
		$custom_loop_options['query_vars'],
		false
	)
);

// Heading
$custom_loop_options['heading']['title'] = [
	'visible' => kalium_validate_boolean( $attributes['showHeading'] ?? false ),
	'text'    => $attributes['title'] ?? '',
	'content' => kalium_format_content( $attributes['description'] ?? '' ),
];

if ( ! empty( $attributes['headingLayout'] ) && 'inherit' !== $attributes['headingLayout'] ) {
	$custom_loop_options['heading']['layout'] = $attributes['headingLayout'];
}

// Filtering
$custom_loop_options['filtering']['enabled'] = kalium_validate_boolean( $attributes['filters'] ?? true );

if ( $custom_loop_options['filtering']['enabled'] ) {
	$filters_options = $attributes['filtersOptions'] ?? [];

	// Get portfolio taxonomies
	$portfolio_taxonomies = kalium()->portfolio->get_taxonomies();

	foreach ( $portfolio_taxonomies as $taxonomy ) {
		if ( kalium_validate_boolean( $filters_options[ $taxonomy ]['enabled'] ?? false ) ) {
			$custom_loop_options['filtering']['taxonomies'][] = $taxonomy;

			if ( ! empty( $filters_options[ $taxonomy ]['defaultFilter'] ) ) {
				$custom_loop_options['filtering']['current'][ $taxonomy ] = $filters_options[ $taxonomy ]['defaultFilter'];
			}
		}
	}
}

// Layout type
if ( ! empty( $attributes['layoutType'] ) && 'inherit' !== $attributes['layoutType'] ) {
	$custom_loop_options['layout'] = $attributes['layoutType'];
}

// Layout mode (masonry or fit rows)
if ( ! empty( $attributes['layoutMode'] ) && 'inherit' !== $attributes['layoutMode'] ) {
	$custom_loop_options['grid']['masonry']['mode'] = $attributes['layoutMode'];
}

// Reveal effect
if ( ! empty( $attributes['revealEffect'] ) && 'inherit' !== $attributes['revealEffect'] ) {
	$custom_loop_options['item']['aov']['enabled']          = 'none' !== $attributes['revealEffect'];
	$custom_loop_options['item']['aov']['legacy_animation'] = $attributes['revealEffect'];
	$custom_loop_options['item']['aov']['animation']        = null;
}

// Grid columns
$custom_loop_options['grid']['columns'] = array_merge(
	kalium_get_theme_option( 'portfolio_grid_columns' ),
	array_filter(
		[
			'desktop' => $attributes['columns'] ?? null,
			'tablet'  => $attributes['columnsTablet'] ?? null,
			'mobile'  => $attributes['columnsMobile'] ?? null,
		]
	)
);

// Grid gap
$custom_loop_options['grid']['gap'] = array_merge(
	kalium_get_theme_option( 'portfolio_grid_columns_gap' ),
	array_filter(
		[
			'desktop' => $attributes['columnsGap'] ?? null,
			'tablet'  => $attributes['columnsGapTablet'] ?? null,
			'mobile'  => $attributes['columnsGapMobile'] ?? null,
		]
	)
);

// Custom masonry
if ( kalium_validate_boolean( $attributes['customMasonry'] ?? false ) ) {
	$masonry_items = $attributes['customMasonryItems'] ?? [];

	if ( ! empty( $masonry_items ) ) {
		$custom_loop_options['custom_masonry'] = array_map( static function( $item ) { return [ 'box_size' => $item ];  }, $masonry_items );
	}
}

// Featured image
if ( ! empty( $attributes['thumbnailImageSize'] ) ) {
	$custom_loop_options['item']['thumbnail']['size'] = $attributes['thumbnailImageSize'];

	// Custom image size
	if ( 'custom' === $attributes['thumbnailImageSize'] ) {
		$custom_size = $attributes['thumbnailImageSizeCustom'] ?? [];

		if ( ! empty( $custom_size['width'] ) && ! empty( $custom_size['height'] ) ) {
			$custom_loop_options['item']['thumbnail']['size'] = [
				$custom_size['width'],
				$custom_size['height'],
				$custom_size['crop'] ?? true,
			];
		}
	}
}

// Aspect ratio
if ( ! empty( $attributes['thumbnailAspectRatio'] ) && 'inherit' !== $attributes['thumbnailAspectRatio'] ) {
	$aspect_ratio = $attributes['thumbnailAspectRatio'];

	if ( 'custom' === $aspect_ratio ) {
		$custom_aspect_ratio = $attributes['thumbnailAspectRatioCustom'] ?? [];

		if ( ! empty( $custom_aspect_ratio['width'] ) && ! empty( $custom_aspect_ratio['height'] ) ) {
			$aspect_ratio = $custom_aspect_ratio['width'] . '/' . $custom_aspect_ratio['height'];
		}
	}

	$custom_loop_options['item']['thumbnail']['aspect_ratio'] = $aspect_ratio;
}

// Pagination
$pagination = $attributes['pagination'] ?? [];

switch ( $pagination['type'] ) {
	case 'load-more':
		$custom_loop_options['pagination']['enabled']                      = true;
		$custom_loop_options['pagination']['type']                         = 'load-more';
		$custom_loop_options['pagination']['load_more']['infinite_scroll'] = $pagination['autoReveal'];

		if ( ! empty( $pagination['buttonText'] ) ) {
			$custom_loop_options['pagination']['load_more']['view_more_text'] = $pagination['buttonText'];
		}

		if ( ! empty( $pagination['reachedEndText'] ) ) {
			$custom_loop_options['pagination']['load_more']['last_page_text'] = $pagination['reachedEndText'];
		}
		break;

	case 'static':
		$custom_loop_options['pagination'] = [
			'enabled'   => true,
			'type'      => 'more-link',
			'more_link' => [
				'url'    => $pagination['buttonLink'],
				'text'   => $pagination['buttonText'] ?? null,
			],
		];
		break;

	default:
		$custom_loop_options['pagination']['enabled'] = false;
}

// Instance ID
if ( ! isset( $GLOBALS['kalium_portfolio_items_block_instance_id'] ) ) {
	$GLOBALS['kalium_portfolio_items_block_instance_id'] = 0;
}

$instance_id = ++$GLOBALS['kalium_portfolio_items_block_instance_id'];

// Initialize portfolio loop options
kalium_init_portfolio_loop_options( 'portfolio-items-block-' . $instance_id, $custom_loop_options );

// Block wrapper start
echo '<div ' . get_block_wrapper_attributes() . '>';

// Heading
kalium_portfolio_loop_heading();

// Loop before
kalium_portfolio_loop_before();

// Portfolio items
kalium_portfolio_items_loop();

// Pagination
kalium_portfolio_items_pagination();

// Loop after
kalium_portfolio_loop_after();

// Reset portfolio loop options
kalium_reset_portfolio_loop_options();

// Block wrapper end
echo '</div>';
