<?php
/**
 * Kalium WordPress Theme
 *
 * Template Part Content Section widget.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Plugin;
use Elementor\Widget_Base;

class Content_Section extends Widget_Base {

	/**
	 * Register widget.
	 */
	public static function register() {
		Plugin::instance()->widgets_manager->register( new self() );
	}

	/**
	 * Widget name.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'kalium-content-section';
	}

	/**
	 * Widget title.
	 *
	 * @return string
	 */
	public function get_title() {
		return 'Content Section';
	}

	/**
	 * Widget icon.
	 *
	 * @return string
	 */
	public function get_icon() {
		return 'eicon-kit-parts';
	}

	/**
	 * Widget category.
	 *
	 * @return array
	 */
	public function get_categories() {
		return [ 'kalium' ];
	}

	/**
	 * Get list of available sections.
	 *
	 * @return array
	 */
	protected function get_sections_list() {
		$choice_list = [
			'' => 'Select section',
		];

		foreach ( kalium()->template_parts->get_template_parts( [ 'type' => 'section' ] ) as $section ) {
			$choice_list[ "{$section['id']}" ] = $section['title'];
		}

		return $choice_list;
	}

	/**
	 * Register widget controls.
	 */
	protected function register_controls() {

		// Select section
		$this->start_controls_section(
			'select_section',
			[
				'label' => 'Section',
			]
		);

		$this->add_control(
			'section_id',
			[
				'label'   => 'Display Section',
				'type'    => Controls_Manager::SELECT,
				'options' => $this->get_sections_list(),
			]
		);

		$this->add_control(
			'edit_template_part',
			[
				'raw'       => sprintf(
					'<a href="#" onclick="%2$s" class="elementor-button"><i class="eicon-pencil"></i>%1$s</a>',
					'Edit Section',
					"window.open( elementor.config.document.urls.main_dashboard + 'post.php?post=' + elementor.getPanelView().getCurrentPageView().model.get( 'settings' ).attributes.section_id + '&action=edit' )"
				),
				'type'      => Controls_Manager::RAW_HTML,
				'condition' => [
					'section_id!' => '',
				],
			]
		);

		$this->add_control(
			'check_conditions',
			[
				'label'       => 'Check Display Conditions',
				'type'        => Controls_Manager::SWITCHER,
				'label_on'    => 'Yes',
				'label_off'   => 'No',
				'default'     => '',
				'description' => 'Check if this section should be visible based on its Display Conditions.',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render widget output on the frontend.
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		if ( ! empty( $settings['section_id'] ) ) {
			$section_id = $settings['section_id'];

			// Display section
			kalium()->template_parts->render_template_part(
				$section_id,
				[
					'check_conditions' => kalium_validate_boolean( $settings['check_conditions'] ),
				]
			);
		}
	}
}
