<?php
/**
 * Kalium WordPress Theme
 *
 * Kalium internationalization class.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Core;

use stdClass;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class I18n {

	/**
	 * Construct.
	 */
	public function __construct() {
		add_action( 'after_setup_theme', [ $this, 'load_textdomain' ] );
		add_action( 'pre_set_site_transient_update_themes', [ $this, 'theme_translations' ] );
	}

	/**
	 * Load theme text domain.
	 *
	 * @since 4.0
	 */
	public function load_textdomain() {
		load_theme_textdomain( 'kalium', kalium()->locate_file( 'languages' ) );
	}

	/**
	 * Set theme translations.
	 *
	 * @param stdClass $data
	 *
	 * @return stdClass
	 */
	public function theme_translations( $data ) {
		$theme_translations = kalium_api(
			'translations',
			[
				'cache' => DAY_IN_SECONDS,
			]
		);

		if ( ! empty( $theme_translations ) ) {
			$current_locale   = get_locale();
			$find_translation = wp_list_filter(
				$theme_translations,
				[
					'wp_locale' => $current_locale,
				]
			);

			if ( ! empty( $find_translation ) ) {
				$translation_set = kalium_get_array_first( $find_translation );
				$last_modified   = $translation_set['last_modified'] ?? null;

				// Revision date of current loaded locale
				$revision_date = $GLOBALS['l10n']['kalium']->headers['Po-Revision-Date'] ?? null;

				if ( is_null( $revision_date ) || strtotime( $revision_date ) < strtotime( $last_modified ) ) {
					$data->translations[] = [
						'type'       => 'theme',
						'slug'       => kalium()->get_slug(),
						'language'   => $current_locale,
						'version'    => kalium()->get_version(),
						'updated'    => $translation_set['last_modified'] ?? null,
						'package'    => kalium()->endpoint_url(
							'translation-download',
							[
								'file' => $current_locale . '.zip',
							]
						),
						'autoupdate' => true,
					];
				}
			}
		}

		return $data;
	}
}
