<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Align Matrix.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Action_Button extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-action-button';

	/**
	 * Contextual.
	 *
	 * @var bool
	 */
	public $contextual = true;

	/**
	 * Variant.
	 *
	 * @var string
	 */
	public $variant = 'primary';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public $icon;

	/**
	 * Icon size.
	 *
	 * @var int
	 */
	public $icon_size = 18;

	/**
	 * Button title.
	 *
	 * @var string
	 */
	public $button_title;

	/**
	 * Action.
	 *
	 * @var string
	 */
	public $action;

	/**
	 * Execute action in AJAX.
	 *
	 * @var string
	 */
	public $ajax = false;

	/**
	 * Loading text.
	 *
	 * @var string
	 */
	public $loading_text;

	/**
	 * Disabled.
	 *
	 * @var bool
	 */
	public $disabled;

	/**
	 * Size.
	 *
	 * @var string
	 */
	public $size;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['variant']      = $this->variant;
		$this->json['icon']         = $this->icon;
		$this->json['icon_size']    = $this->icon_size;
		$this->json['button_title'] = $this->button_title;
		$this->json['action']       = $this->action;
		$this->json['ajax']         = $this->ajax;
		$this->json['loading_text'] = $this->loading_text;
		$this->json['disabled']     = $this->disabled;
		$this->json['size']         = $this->size;
	}
}
