<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Box Shadow.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Box_Shadow extends Multi_Numeric {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-box-shadow';

	/**
	 * Value props.
	 *
	 * @var array
	 */
	public $value_props = [
		'offset_x'      => 'X',
		'offset_y'      => 'Y',
		'blur_radius'   => 'Blur',
		'spread_radius' => 'Spread',
	];

	/**
	 * Link values.
	 *
	 * @var bool
	 */
	public $link_values = false;

	/**
	 * Show base colors palette.
	 *
	 * @var bool
	 */
	public $base_colors = true;

	/**
	 * Allow color clear.
	 *
	 * @var bool
	 */
	public $enable_color_clear = false;

	/**
	 * Enable color alpha.
	 *
	 * @var bool|array
	 */
	public $enable_color_alpha = true;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['base_colors']        = $this->base_colors;
		$this->json['enable_color_clear'] = $this->enable_color_clear;
		$this->json['enable_color_alpha'] = $this->enable_color_alpha;
	}
}
