<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Box Control.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Box extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-box';

	/**
	 * Split on axis.
	 *
	 * @var bool
	 */
	public $split_on_axis;

	/**
	 * Sides.
	 *
	 * @var array
	 */
	public $sides;

	/**
	 * Units.
	 *
	 * @var array
	 */
	public $units;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['split_on_axis'] = $this->split_on_axis;
		$this->json['sides']         = $this->sides;
		$this->json['units']         = $this->units;
	}
}
