<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Palette.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Palette extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-color';

	/**
	 * Palettes.
	 *
	 * @var array
	 */
	public $palettes;

	/**
	 * Enable alpha.
	 *
	 * @var bool
	 */
	public $enable_alpha = true;

	/**
	 * Enable clear.
	 *
	 * @var bool
	 */
	public $enable_clear;

	/**
	 * Show tooltips.
	 *
	 * @var bool
	 */
	public $tooltip;

	/**
	 * Enables manage mode.
	 *
	 * @var array|false
	 */
	public $manage;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['palettes']     = $this->palettes;
		$this->json['enable_alpha'] = $this->enable_alpha;
		$this->json['enable_clear'] = $this->enable_clear;
		$this->json['tooltip']      = $this->tooltip;
		$this->json['manage']       = $this->manage;
	}
}
