<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Radio image.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Radio_Image extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-radio-image';

	/**
	 * Columns to split radio options.
	 *
	 * @var int|string
	 */
	public $columns = 2;

	/**
	 * Show labels.
	 *
	 * @var bool
	 */
	public $show_labels = true;

	/**
	 * Tooltips.
	 *
	 * @var bool
	 */
	public $tooltips = false;

	/**
	 * Aspect ratio.
	 *
	 * @var string
	 */
	public $aspect_ratio;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['columns']      = $this->columns;
		$this->json['show_labels']  = $this->show_labels;
		$this->json['tooltips']     = $this->tooltips;
		$this->json['aspect_ratio'] = $this->aspect_ratio;
	}
}
