<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Section Link.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Section_Link extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-section-link';

	/**
	 * Section link.
	 *
	 * @var string
	 */
	public $section_link;

	/**
	 * Contextual.
	 *
	 * @param bool
	 */
	public $contextual = true;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * No input for section link control.
	 */
	public function control_input() {}

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		$this->add_class( 'kalium-customize-control--section' );

		// Add JSON data
		parent::to_json();

		// Section link JSON data
		$this->json['inline_label'] = true;
		$this->json['section_link'] = $this->section_link;
	}
}
