<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Textarea.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Textarea extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-textarea';

	/**
	 * Input type.
	 *
	 * @var int
	 */
	public $rows;

	/**
	 * Monospace text.
	 *
	 * @var bool
	 */
	public $monospace;

	/**
	 * Placeholder.
	 *
	 * @var string
	 */
	public $placeholder;

	/**
	 * Inline label.
	 *
	 * @var bool
	 */
	public $inline_label = false;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['rows']        = $this->rows;
		$this->json['monospace']   = $this->monospace;
		$this->json['placeholder'] = $this->placeholder;
	}
}
