<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Toggle.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Toggle extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-toggle';

	/**
	 * Toggle label.
	 *
	 * @var string
	 */
	public $toggle_label;

	/**
	 * Section link.
	 *
	 * @var string
	 */
	public $section_link;

	/**
	 * Disabled state.
	 *
	 * @var bool
	 */
	public $disabled;

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		// If is section link
		if ( ! empty( $this->section_link ) ) {
			$this->add_class( 'is-section-link' );
		}

		// Toggle label
		$this->json['toggle_label'] = $this->toggle_label;
		$this->json['section_link'] = $this->section_link;
		$this->json['disabled']     = $this->disabled;
	}
}
