<?php
/**
 * Kalium WordPress Theme
 *
 * Customizer Control Type: Unit.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Customize\Control_Types;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Unit extends Base_Control {

	/**
	 * Control type.
	 *
	 * @var string
	 */
	public $type = 'kalium-unit';

	/**
	 * Placeholder.
	 *
	 * @var string
	 */
	public $placeholder;

	/**
	 * Step.
	 *
	 * @var int
	 */
	public $step;

	/**
	 * Min.
	 *
	 * @var int
	 */
	public $min;

	/**
	 * Max.
	 *
	 * @var int
	 */
	public $max;

	/**
	 * Prefix.
	 *
	 * @var string
	 */
	public $prefix;

	/**
	 * Units.
	 *
	 * @var array
	 */
	public $units;

	/**
	 * Reset value on unit change.
	 *
	 * @var bool
	 */
	public $unit_reset_value = false;

	/**
	 * Shift step.
	 *
	 * @var int
	 */
	public $shift_step = 10;

	/**
	 * Enable drag.
	 *
	 * @var bool
	 */
	public $drag_enabled = true;

	/**
	 * Drag threshold.
	 *
	 * @var int
	 */
	public $drag_threshold = 10;

	/**
	 * Drag direction.
	 *
	 * @var string
	 */
	public $drag_direction = 'n';

	/**
	 * Add JSON data.
	 */
	public function to_json() {
		parent::to_json();

		$this->json['placeholder']      = $this->placeholder;
		$this->json['step']             = $this->step;
		$this->json['min']              = $this->min;
		$this->json['max']              = $this->max;
		$this->json['prefix']           = $this->prefix;
		$this->json['units']            = $this->units;
		$this->json['unit_reset_value'] = $this->unit_reset_value;
		$this->json['shift_step']       = $this->shift_step;
		$this->json['drag_enabled']     = $this->drag_enabled;
		$this->json['drag_threshold']   = $this->drag_threshold;
		$this->json['drag_direction']   = $this->drag_direction;
	}
}
