<?php
/**
 * Kalium WordPress Theme
 *
 * Page operations.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Features;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Page {

	/**
	 * Page heading.
	 *
	 * @var array
	 */
	public $page_heading = [
		'visible'     => false,
		'tag'         => 'h1',
		'title'       => null,
		'description' => null,
	];

	/**
	 * Set page heading visibility.
	 *
	 * @param array $options
	 *
	 * @return self
	 */
	public function set_page_heading( $options ) {
		if ( is_array( $options ) ) {
			foreach ( $options as $key => $value ) {
				if ( array_key_exists( $key, $this->page_heading ) ) {
					$this->page_heading[ $key ] = $value;
				}
			}
		}

		return $this;
	}

	/**
	 * Get page heading tag.
	 *
	 * @param string $option_name
	 *
	 * @return mixed
	 */
	public function get_page_heading( $option_name ) {
		return $this->page_heading[ $option_name ] ?? null;
	}

	/**
	 * Show page heading.
	 *
	 * @param bool $visible
	 *
	 * @return bool
	 */
	public function show_page_heading( $visible = null ) {
		if ( ! is_null( $visible ) ) {
			$this->set_page_heading(
				[
					'visible' => boolval( $visible ),
				]
			);
		}

		return $this->get_page_heading( 'visible' );
	}
}
