<?php
/**
 * Kalium WordPress Theme
 *
 * Custom Post Types compatibility.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Integrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Custom_Post_Types {

	/**
	 * Get supported post types.
	 *
	 * @return array
	 */
	public function get_supported_post_types() {
		static $post_types_cached;

		if ( ! is_null( $post_types_cached ) ) {
			return $post_types_cached;
		}

		$post_types = array_values(
			get_post_types(
				[
					'public'   => true,
					'_builtin' => false,
				]
			)
		);

		$ignored_post_types = $this->get_ignored_post_types();

		$post_types = array_values(
			array_filter(
				$post_types,
				function ( $post_type ) use ( $ignored_post_types ) {
					foreach ( $ignored_post_types as $ignored_post_type ) {
						if ( ! $ignored_post_type ) {
							continue;
						}

						if ( $post_type === $ignored_post_type ) {
							return false;
						} elseif ( false !== strpos( $ignored_post_type, '*' ) && preg_match( '/^' . str_replace( '*', '[\w]+', $ignored_post_type ) . '/', $post_type ) ) {
							return false;
						}
					}

					return true;
				}
			)
		);

		$post_types_cached = apply_filters( 'kalium_supported_post_types', $post_types );

		return $post_types_cached;
	}

	/**
	 * Get ignored post types.
	 *
	 * @return array
	 */
	public function get_ignored_post_types() {
		return apply_filters(
			'kalium_ignored_post_types',
			[
				// Legacy portfolio post type
				kalium()->is->portfolio_active() ? 'portfolio' : null,

				// WooCommerce
				'product',

				// Other post types
				'elementor_library',
				'jet-*',
				'llms-*',
			]
		);
	}
}
