<?php
/**
 * Kalium WordPress Theme
 *
 * Other integrations.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Integrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class Other {

	/**
	 * Construct.
	 */
	public function __construct() {
		// TGM plugin activation
		$this->tgmpa_integration();

		// Laborator libraries
		$this->laborator_libraries();

		// Portfolio Post type
		$this->portfolio_post_type();

		// WooCommerce Germanized
		$this->woocommerce_germanized();

		// Theme demo
		$this->theme_demo_integration();

		// Other integrations
		$this->other_integrations();
	}

	/**
	 * Laborator libraries.
	 */
	private function laborator_libraries() {
		kalium()->require_file( 'includes/libraries/laborator/typolab/typolab.php' );
		kalium()->require_file( 'includes/libraries/laborator/laborator-builder/laborator-builder.php' );
		kalium()->require_file( 'includes/libraries/laborator/importer/importer.php' );
		kalium()->require_file( 'includes/libraries/laborator/custom-css/custom-css.php' );
		kalium()->require_file( 'includes/libraries/laborator/grouped-metaboxes/grouped-metaboxes.php' );
	}

	/**
	 * TGMPA integration.
	 */
	private function tgmpa_integration() {
		kalium()->require_file( 'includes/libraries/class-tgm-plugin-activation.php' );
	}

	/**
	 * Portfolio post type.
	 */
	private function portfolio_post_type() {
		global $pagenow;

		// When importing demo content, temporarily activate portfolio post type
		if ( 'kalium_importer_run_action' === kalium()->request->request( 'action' ) && 'content' === kalium()->request->xhr_request( 'import-id' ) && current_user_can( 'install_plugins' ) ) {
			add_filter( 'pre_option_kalium_portfolio_post_type', '__return_true' );
		}

		// Plugin is active or disabled by the user
		if ( false === wp_validate_boolean( get_option( 'kalium_portfolio_post_type' ) ) || class_exists( 'Portfolio_Post_Type' ) ) {
			return;
		}

		// Activating the plugin
		if (
			is_admin()
			&& 'plugins.php' === $pagenow
			&& 'activate' === kalium()->request->query( 'action' )
			&& 'portfolio-post-type/portfolio-post-type.php' === kalium()->request->query( 'plugin' )
			&& current_user_can( 'activate_plugins' )
		) {
			return;
		}

		kalium()->require_file( 'includes/libraries/portfolio-post-type/portfolio-post-type.php' );
	}

	/**
	 * WooCommerce Germanized integration.
	 */
	private function woocommerce_germanized() {
		if ( ! class_exists( 'WooCommerce_Germanized' ) ) {
			return;
		}

		// Disable checkout thumbnail as the theme supports them by default
		add_filter( 'option_woocommerce_gzd_display_checkout_thumbnails', '__return_false' );
	}

	/**
	 * Theme demo integration.
	 */
	private function theme_demo_integration() {
		if ( $theme_demo_file = kalium()->locate_file( 'theme-demo/index.php' ) ) {
			require_once $theme_demo_file;
		}
	}

	/**
	 * Other integrations.
	 */
	private function other_integrations() {
		kalium()->require_file( 'includes/libraries/dynamic-image-downsize.php' );
	}
}
