<?php
/**
 * Kalium WordPress Theme
 *
 * Kalium WooCommerce compatibility class.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Integrations\WooCommerce;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

class WooCommerce {

	/**
	 * Construct.
	 */
	public function __construct() {
		if ( ! kalium()->is->woocommerce_active() ) {
			return;
		}

		add_action( 'after_setup_theme', [ $this, 'init' ] );
		add_action( 'wp_head', [ $this, 'maybe_support_wc_gallery' ], 0 );
	}

	/**
	 * Init.
	 */
	public function init() {
		// WooCommerce support
		add_theme_support(
			'woocommerce',
			apply_filters(
				'kalium_theme_support_woocommerce',
				[
					'gallery_thumbnail_image_width' => 220,
				]
			)
		);

		// Gallery zoom is used by WooCommerce default gallery and theme as well
		add_theme_support( 'wc-product-gallery-zoom' ); // TODO: Connect zoom support with theme option toggle
	}

	/**
	 * Get single image width.
	 *
	 * @return int|null
	 */
	public function get_single_image_width() {
		if ( ! kalium()->is->woocommerce_active() ) {
			return null;
		}

		return absint( wc_get_theme_support( 'single_image_width', get_option( 'woocommerce_single_image_width', 820 ) ) );
	}

	/**
	 * Maybe support WooCommerce gallery.
	 * 
	 * @since 4.4.3
	 */
	public function maybe_support_wc_gallery() {
		// Support for built-in WooCommerce gallery components
		if ( kalium_woocommerce_use_default_image_gallery() ) {
			add_theme_support( 'wc-product-gallery-slider' );
			add_theme_support( 'wc-product-gallery-lightbox' );
		}
	}
}
