<?php
/**
 * Template Parts Elementor document.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
namespace Kalium\Template_Parts;

use Elementor\Core\Base\Document;

class Elementor_Document extends Document {

	/**
	 * Get the unique document type identifier.
	 *
	 * @return string
	 */
	public static function get_type() {
		return Template_Parts::POST_TYPE . '_document';
	}

	/**
	 * Get Properties.
	 *
	 * @return array
	 */
	public static function get_properties() {
		$properties = parent::get_properties();

		$properties['cpt'] = [
			Template_Parts::POST_TYPE,
		];

		$properties['support_kit'] = true;

		return $properties;
	}

	/**
	 * Get the display title of the document.
	 *
	 * @return string
	 */
	public static function get_title() {
		return 'Template Part';
	}

	/**
	 * Get the post type this document applies to.
	 *
	 * @return string
	 */
	public static function get_post_type() {
		return Template_Parts::POST_TYPE;
	}

	/**
	 * Get the internal document name.
	 *
	 * @return string
	 */
	public function get_name() {
		return Template_Parts::POST_TYPE;
	}
}
