<?php
/**
 * Kalium WordPress Theme
 *
 * Alias functions.
 *
 * @author Laborator
 * @link https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Get Theme Options data entry.
 *
 * @param string $option_name
 * @param bool   $default_value
 *
 * @return mixed
 *
 * @deprecated 3.0
 * @see kalium_get_theme_option()
 */
function get_data( $option_name = null, $default_value = false ) {
	return kalium_get_theme_option( $option_name, $default_value );
}

/**
 * Get element from array by key (fail safe).
 *
 * @param array  $arr
 * @param string $key
 *
 * @return mixed|null
 *
 * @deprecated 3.0
 * @see kalium_get_array_key()
 */
function get_array_key( $arr, $key, $default_value = null ) {
	return kalium_get_array_key( $arr, $key, $default_value );
}

/**
 * Custom style generator.
 *
 * @param string $selector
 * @param string $props
 * @param string $media
 * @param bool   $footer
 *
 * @return void
 *
 * @deprecated 3.0
 * @see        kalium_append_custom_css()
 */
function generate_custom_style( $selector, $props = '', $media = '', $footer = false ) {
	kalium_append_custom_css( $selector, $props, $media, $footer );
}

/**
 * Get SVG file contents from theme directory.
 *
 * @param string $svg_path
 * @param string $id
 * @param int[]  $size
 * @param bool   $is_asset
 *
 * @return string
 *
 * @deprecated 3.0
 * @see kalium_get_svg_file()
 */
function laborator_get_svg( $svg_path, $id = null, $size = [ 24, 24 ], $is_asset = true ) {
	$file_path = $is_asset ? "assets/{$svg_path}" : $svg_path;

	return kalium_get_svg_file( $file_path, $id, $size );
}

/**
 * Print HTML element.
 *
 * @param array $args
 *
 * @return string
 *
 * @deprecated 4.2
 * @see kalium_render_element()
 */
function kalium_element( $args ) {
	$echo = true;

	// Deprecated string function arguments
	if ( is_string( $args ) ) {
		_deprecated_argument(
			__FUNCTION__,
			'4.2',
			'Passing string-based arguments to kalium_element() is deprecated. Use an associative array instead: kalium_element( [ "tag_name" => "div", "attributes" => [], "content" => "", "close" => true ] ).'
		);

		$func_args = func_get_args();

		$args = [
			'tag_name'   => $func_args[0] ?? '',
			'attributes' => $func_args[1] ?? [],
			'content'    => $func_args[2] ?? null,
			'close'      => $func_args[3] ?? true,
		];
	} elseif ( is_array( $args ) ) {
		$echo = $args['echo'] ?? false;
	}

	return kalium_render_element( $args, $echo );
}

/**
 * Print element attributes.
 *
 * @param array $attributes
 * @param bool  $echo
 *
 * @return string|void
 * @deprecated 4.2
 * @see kalium_render_attributes()
 */
function kalium_attributes() {
	return call_user_func_array( [ kalium()->helpers, 'render_attributes' ], func_get_args() );
}
