<?php
/**
 * Kalium WordPress Theme
 *
 * Core template hooks.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Site wrapper
add_action( 'kalium_wrapper_start', 'kalium_site_wrapper_start', 0 );
add_action( 'kalium_wrapper_end', 'kalium_site_wrapper_end', 99999 );

// Site footer
add_action( 'kalium_wrapper_end', 'kalium_footer_display' );

// Footer content
add_action( 'kalium_footer', 'kalium_footer_default_template' );

// Default excerpt length and more dot
add_filter( 'excerpt_length', 'kalium_default_excerpt_length', 10 );
add_filter( 'excerpt_more', 'kalium_default_excerpt_more', 100 );

// Map WPBakery Shortcodes for Product Filter AJAX request
add_action( 'wp_ajax_prdctfltr_respond_550', 'WPBMap::addAllMappedShortcodes', 5 );
add_action( 'wp_ajax_nopriv_prdctfltr_respond_550', 'WPBMap::addAllMappedShortcodes', 5 );

// Disable jQuery migrate
add_action( 'wp_default_scripts', 'kalium_performance_disable_jquery_migrate' );

// Disable WordPress Emoji library
add_action( 'wp_enqueue_scripts', 'kalium_performance_disable_wp_emoji' );

// Disable WordPress Embed library
add_action( 'wp_enqueue_scripts', 'kalium_performance_disable_wp_embed' );

// JPEG quality
add_filter( 'jpeg_quality', 'kalium_performance_jpeg_quality' );

// Search page
add_action( 'kalium_search_page', 'kalium_search_page_content_wrapper_start' );
add_action( 'kalium_search_page', 'kalium_content_wrapper_main_content_start', 20 );
add_action( 'kalium_search_page', 'kalium_search_results_info', 30 );
add_action( 'kalium_search_page', 'kalium_search_results', 40 );
add_action( 'kalium_search_page', 'kalium_content_wrapper_main_content_end', 50 );
add_action( 'kalium_search_page', 'kalium_search_page_content_wrapper_end', 60 );

// Search result loop item
add_action( 'kalium_search_result_loop_item', 'kalium_search_result_item_default_template' );

// Search result entry details
add_action( 'kalium_search_result_entry_image', 'kalium_search_result_thumbnail' );
add_action( 'kalium_search_result_entry_content', 'kalium_search_result_title' );
add_action( 'kalium_search_result_entry_content', 'kalium_search_result_excerpt', 20 );
add_action( 'kalium_search_result_entry_actions', 'kalium_search_result_read_more' );
