<?php
/**
 * Kalium WordPress Theme
 *
 * Theme header actions and filters.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Site header, top header bar, breadcrumb and heading title display.
 */
add_action( 'kalium_wrapper_start', 'kalium_header_default_template', 10 );
add_action( 'kalium_wrapper_start', 'kalium_page_heading_default_template', 20 );

/**
 * Before wrapper hooks.
 */
add_action( 'kalium_before_wrapper', 'kalium_site_frame', 10 );
add_action( 'kalium_before_wrapper', 'kalium_mobile_menu_default_template', 20 );
add_action( 'kalium_before_wrapper', 'kalium_header_off_canvas_top_menu_default_template', 30 );
add_action( 'kalium_before_wrapper', 'kalium_header_off_canvas_side_menu_default_template', 40 );

/**
 * Mobile menu.
 */

/**
 * Header display function.
 */
add_action( 'kalium_header_content', 'kalium_header_top_bar_display', 10 );
add_action( 'kalium_header_content', 'kalium_header_content_display', 20 );
add_action( 'kalium_header_content', 'kalium_header_fullscreen_menu_display', 30 );

/**
 * Header content for main row.
 */
add_action( 'kalium_header_content_main', 'kalium_header_content_left', 10 );
add_action( 'kalium_header_content_main', 'kalium_header_content_logo', 20 );
add_action( 'kalium_header_content_main', 'kalium_header_content_right', 30 );

/**
 * Header content after main row.
 */
add_action( 'kalium_header_content_after', 'kalium_header_content_below', 10 );
