<?php
/**
 * Kalium WordPress Theme
 *
 * Page template functions.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

if ( ! function_exists( 'kalium_page_content_wrapper_start' ) ) {

	/**
	 * Page content wrapper start.
	 */
	function kalium_page_content_wrapper_start() {
		kalium_content_wrapper_start(
			'page',
			[
				'container_fullwidth' => true,
			]
		);
	}
}

if ( ! function_exists( 'kalium_page_content_wrapper_end' ) ) {

	/**
	 * Page content wrapper start.
	 */
	function kalium_page_content_wrapper_end() {
		kalium_content_wrapper_end( 'page' );
	}
}

if ( ! function_exists( 'kalium_page_heading_default_template' ) ) {

	/**
	 * Page heading title display.
	 */
	function kalium_page_heading_default_template() {
		if ( ! kalium()->page->show_page_heading() || kalium_is_maintenance_mode() ) {
			return;
		}

		kalium_page_heading(
			[
				'heading_tag' => kalium()->page->get_page_heading( 'tag' ),
				'title'       => kalium()->page->get_page_heading( 'title' ),
				'description' => kalium()->page->get_page_heading( 'description' ),
			]
		);
	}
}

if ( ! function_exists( 'kalium_404_default_template' ) ) {

	/**
	 * 404 default template.
	 *
	 * @since 4.4.3
	 */
	function kalium_404_default_template() {
		?>
		<div class="container">
			<div class="not-found">
				<div class="not-found__box">
					<div class="not-found__404">
						<span class="flashing-num">4</span>
						<span class="flashing-num del-1">0</span>
						<span class="flashing-num del-2">4</span>
					</div>
				</div>
				<h1 class="not-found__title"><?php esc_html_e( 'Not found!', 'kalium' ); ?></h1>
				<p><?php printf( __( 'We’re sorry, the page you have looked for does not exist in our database! <br /> Perhaps you would like to go to our <a href="%s">home page</a>?', 'kalium' ), home_url() ); ?></p>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'kalium_comments_default_template' ) ) {

	/**
	 * Comments default template.
	 *
	 * @since 4.4.3
	 */
	function kalium_comments_default_template() {
		$container_classes = [
			'container',
			kalium_if_else( kalium_is_narrow_blog_layout(), 'container-narrow' ),
		];

		// Comments list
		if ( have_comments() ) :
			$comments_number  = get_comments_number();
			$comments_classes = [
				'comments-list',
			];

			if ( ! get_option( 'show_avatars' ) ) {
				$comments_classes[] = 'comments-list--no-avatars';
			}

			/**
			 * Before comments hook.
			 */
			do_action( 'kalium_comments_before' );

			?>
			<section id="comments" class="post-comments">
				<div <?php kalium_class_attr( $container_classes ); ?>>
					<div class="post-comments__section-title">
						<h2><?php printf( _n( '1 Comment', '%d Comments', $comments_number, 'kalium' ), $comments_number ); ?></h2>
						<p><?php $comments_number > 0 ? esc_html_e( 'Join the discussion and tell us your opinion.', 'kalium' ) : esc_html_e( 'Be the first to comment on this article.', 'kalium' ); ?></p>
					</div>

					<?php
					/**
					 * Before comments list hooks.
					 */
					do_action( 'kalium_comments_list_before' );
					?>

					<ul <?php kalium_class_attr( $comments_classes ); ?>>
						<?php
						// Comments List
						wp_list_comments(
							[
								'callback'     => 'kalium_blog_post_comment',
								'end-callback' => 'kalium_blog_post_comment_end',
							]
						);
						?>
					</ul>

					<?php
						// Comments pagination
						kalium_comments_pagination();
					?>
				</div>

			</section>
			<?php

			/**
			 * After comments hooks.
			 */
			do_action( 'kalium_comments_after' );

		endif;
	}
}

if ( ! function_exists( 'kalium_comment_form_default_template' ) ) {

	/**
	 * Comment form default template.
	 *
	 * @since 4.4.3
	 */
	function kalium_comment_form_default_template() {
		$container_classes = [
			'container',
			kalium_if_else( kalium_is_narrow_blog_layout(), 'container-narrow' ),
		];

		// Post comment form
		if ( comments_open() ) :
			?>
			<section class="post-comment-form">
				<div <?php kalium_class_attr( $container_classes ); ?>>
					<?php
					comment_form(
						[
							'format'               => 'html5',
							'title_reply'          => have_comments() ? esc_html__( 'Leave a reply', 'kalium' ) : esc_html__( 'Share your thoughts', 'kalium' ),
							'title_reply_to'       => esc_html__( 'Reply to %s', 'kalium' ),
							'comment_notes_before' => '',
							'comment_notes_after'  => '',
							'label_submit'         => esc_html__( 'Comment', 'kalium' ),
							'class_submit'         => 'button',
						]
					);
					?>
				</div>
			</section>
			<?php
		endif;
	}
}
