<?php
/**
 * Kalium WordPress Theme
 *
 * WooCommerce hooks functions.
 *
 * @author Laborator
 * @link   https://kaliumtheme.com
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

/**
 * Disable WooCommerce default styles.
 */
add_filter( 'woocommerce_enqueue_styles', '__return_false' );

/**
 * Shop pagination.
 */
remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination' );

add_action( 'woocommerce_after_shop_loop', 'kalium_woocommerce_pagination' );

/**
 * Archive wrapper.
 */
add_action( 'woocommerce_before_main_content', 'kalium_woocommerce_archive_wrapper_start', 5 );
add_action( 'woocommerce_after_main_content', 'kalium_woocommerce_archive_wrapper_end', 1000 );

/**
 * Shop archive sidebar.
 */
add_action( 'woocommerce_after_main_content', 'kalium_woocommerce_archive_sidebar', 990 );

/**
 * Shop archive heading.
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );

add_action( 'woocommerce_before_main_content', 'kalium_woocommerce_shop_heading', 3 );
add_filter( 'woocommerce_show_page_title', '__return_false', 100 );

/**
 * Remove default archive header.
 */
remove_action( 'woocommerce_shop_loop_header', 'woocommerce_product_taxonomy_archive_header' );

/**
 * Shop archive heading elements.
 */
add_action( 'kalium_woocommerce_shop_heading', 'kalium_woocommerce_breadcrumb_display', 10 );
add_action( 'kalium_woocommerce_shop_heading', 'kalium_woocommerce_page_title_display', 20 );
add_action( 'kalium_woocommerce_shop_heading', 'kalium_woocommerce_archive_description_display', 30 );

/**
 * Shop toolbar.
 */
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

add_action( 'kalium_woocommerce_shop_heading', 'kalium_woocommerce_shop_toolbar', 100 );

/**
 * Shop toolbar elements.
 */
add_action( 'kalium_woocommerce_shop_toolbar_left', 'kalium_woocommerce_result_count_display', 10 );
add_action( 'kalium_woocommerce_shop_toolbar_right', 'kalium_woocommerce_filters_toggle_display', 10 );
add_action( 'kalium_woocommerce_shop_toolbar_right', 'kalium_woocommerce_columns_switcher_display', 20 );
add_action( 'kalium_woocommerce_shop_toolbar_right', 'kalium_woocommerce_catalog_ordering_display', 30 );

/**
 * Single product wrapper.
 */
add_action( 'woocommerce_before_main_content', 'kalium_woocommerce_single_wrapper_start', 1 );
add_action( 'woocommerce_after_main_content', 'kalium_woocommerce_single_wrapper_end', 1000 );

/**
 * Single product main content wrapper.
 */
add_action( 'woocommerce_before_single_product_summary', 'kalium_woocommerce_single_summary_wrapper_start', 0 );
add_action( 'woocommerce_after_single_product_summary', 'kalium_woocommerce_single_summary_wrapper_end', 0 );

/**
 * Single product gallery wrapper.
 */
add_action( 'woocommerce_before_single_product_summary', 'kalium_woocommerce_single_gallery_wrapper_start', 0 );
add_action( 'woocommerce_before_single_product_summary', 'kalium_woocommerce_single_gallery_wrapper_end', 990 );

/**
 * Single product sale badge.
 */
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash' );

add_action( 'woocommerce_before_single_product_summary', 'kalium_woocommerce_single_product_badge_display', 5 );

/**
 * Single product sidebar.
 */
add_action( 'woocommerce_after_main_content', 'kalium_woocommerce_single_sidebar', 990 );

/**
 * Single product header.
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );

add_action( 'woocommerce_single_product_summary', 'kalium_woocommerce_single_product_header', 5 );

/**
 * Single product header elements.
 */
add_action( 'kalium_woocommerce_single_product_header', 'woocommerce_template_single_title' );

/**
 * Single product price placement.
 */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 25 );

/**
 * Single product meta.
 */
if ( isset( $GLOBALS['WC_Brands'] ) ) {
	remove_action( 'woocommerce_product_meta_end', [ $GLOBALS['WC_Brands'], 'show_brand' ] );
}

add_action( 'woocommerce_product_meta_end', 'kalium_woocommerce_single_product_sku', 10 );
add_action( 'woocommerce_product_meta_end', 'kalium_woocommerce_single_product_category', 20 );
add_action( 'woocommerce_product_meta_end', 'kalium_woocommerce_single_product_brands', 25 );
add_action( 'woocommerce_product_meta_end', 'kalium_woocommerce_single_product_tags', 30 );
add_action( 'woocommerce_product_meta_end', 'kalium_woocommerce_single_product_social_share', 40 );

/**
 * Show rating below top-rated products widget,
 */
add_action( 'woocommerce_widget_product_item_end', 'kalium_woocommerce_top_rated_products_widget_rating', 10 );

/**
 * Empty cart page.
 */
remove_filter( 'woocommerce_cart_is_empty', 'wc_empty_cart_message' );

add_action( 'woocommerce_cart_is_empty', 'kalium_woocommerce_empty_cart_message' );

/**
 * Cart page.
 */
add_action( 'woocommerce_before_cart', 'kalium_woocommerce_cart_checkout_heading', 10 );

/**
 * Cart page wrappers.
 */
add_action( 'woocommerce_before_cart', 'kalium_woocommerce_cart_wrapper_start', 11 );
add_action( 'woocommerce_after_cart', 'kalium_woocommerce_cart_wrapper_end', 100 );

add_action( 'woocommerce_before_cart', 'kalium_woocommerce_cart_form_wrapper_start', 12 );
add_action( 'woocommerce_before_cart_collaterals', 'kalium_woocommerce_cart_form_wrapper_end', 1 );

add_action( 'woocommerce_before_cart_collaterals', 'kalium_woocommerce_cart_collaterals_wrapper_start', 2 );
add_action( 'woocommerce_after_cart', 'kalium_woocommerce_cart_collaterals_wrapper_end', 99 );

/**
 * Cross sales reposition.
 */
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );

add_action( 'woocommerce_after_cart', 'kalium_woocommerce_cross_sell_display', 110 );

/**
 * Coupon form in cart totals and review order table.
 */
add_action( 'woocommerce_cart_totals_before_order_total', 'kalium_woocommerce_coupon_form' );
add_action( 'woocommerce_review_order_before_order_total', 'kalium_woocommerce_coupon_form' );

/**
 * Checkout page.
 */
remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10 );

add_action( 'woocommerce_before_checkout_form', 'kalium_woocommerce_cart_checkout_heading', 1 );
add_action( 'woocommerce_before_checkout_form', 'kalium_woocommerce_checkout_login_form', 10 );
add_action( 'kalium_page_heading_after', 'kalium_woocommerce_checkout_login_form_toggle' );

/**
 * Order review wrapper.
 */
add_action( 'woocommerce_checkout_order_review', 'kalium_woocommerce_checkout_order_review_wrapper_start', 1 );
add_action( 'woocommerce_checkout_order_review', 'kalium_woocommerce_checkout_order_review_wrapper_end', 100 );

/**
 * Cart totals and payment methods sepearator.
 */
add_action( 'woocommerce_review_order_after_order_total', 'kalium_woocommerce_order_details_separator' );

/**
 * Order review products separator.
 */
add_action( 'woocommerce_review_order_after_cart_contents', 'kalium_woocommerce_order_review_cart_items_separator' );

/**
 * Create account button in WooCommerce login tab.
 */
add_action( 'woocommerce_login_form_end', 'kalium_woocommerce_my_account_create_account_button', 100 );

/**
 * Back to login form button in WooCommerce my account page.
 */
add_action( 'woocommerce_register_form_end', 'kalium_woocommerce_my_account_back_to_login_button', 100 );

/**
 * Login form wrapper in my account page.
 */
add_action( 'woocommerce_before_customer_login_form', 'kalium_woocommerce_customer_login_form_wrapper_start' );
add_action( 'woocommerce_after_customer_login_form', 'kalium_woocommerce_customer_login_form_wrapper_end', 100 );

/**
 * Lost password page.
 */
add_action( 'woocommerce_before_lost_password_form', 'kalium_woocommerce_customer_login_form_wrapper_start' );
add_action( 'woocommerce_after_lost_password_form', 'kalium_woocommerce_customer_login_form_wrapper_end', 100 );

add_action( 'woocommerce_before_lost_password_form', 'kalium_woocommerce_lost_password_wrapper_start' );
add_action( 'woocommerce_after_lost_password_form', 'kalium_woocommerce_lost_password_wrapper_end', 99 );

add_action( 'woocommerce_before_lost_password_form', 'kalium_woocommerce_lost_password_form_heading' );

add_action( 'woocommerce_after_lost_password_form', 'kalium_woocommerce_lost_password_back_link' );

/**
 * Lost password confirmation page.
 */
add_action( 'woocommerce_before_lost_password_confirmation_message', 'kalium_woocommerce_customer_login_form_wrapper_start' );
add_action( 'woocommerce_after_lost_password_confirmation_message', 'kalium_woocommerce_customer_login_form_wrapper_end', 100 );

add_action( 'woocommerce_before_lost_password_confirmation_message', 'kalium_woocommerce_lost_password_wrapper_start' );
add_action( 'woocommerce_after_lost_password_confirmation_message', 'kalium_woocommerce_lost_password_wrapper_end', 99 );

/**
 * Reset password page.
 */
add_action( 'woocommerce_before_reset_password_form', 'kalium_woocommerce_customer_login_form_wrapper_start' );
add_action( 'woocommerce_after_reset_password_form', 'kalium_woocommerce_customer_login_form_wrapper_end', 100 );

add_action( 'woocommerce_before_reset_password_form', 'kalium_woocommerce_lost_password_wrapper_start' );
add_action( 'woocommerce_after_reset_password_form', 'kalium_woocommerce_lost_password_wrapper_end', 99 );

add_action( 'woocommerce_before_reset_password_form', 'kalium_woocommerce_lost_password_form_heading' );

/**
 * My account page.
 */
add_action( 'woocommerce_before_account_navigation', 'kalium_woocommerce_myaccount_navigation_user_profile' );

// Page headings in my account page
add_action( 'kalium_woocommerce_account_dashboard_before', 'kalium_woocommerce_my_account_dashboard_heading' );
add_action( 'woocommerce_before_account_orders', 'kalium_woocommerce_my_account_orders_heading' );
add_action( 'woocommerce_before_account_downloads', 'kalium_woocommerce_my_account_downloads_heading' );
add_action( 'woocommerce_before_edit_account_form', 'kalium_woocommerce_myaccount_edit_account_heading' );
add_action( 'woocommerce_before_edit_account_address_form', 'kalium_woocommerce_myaccount_edit_address_heading' );
add_action( 'before_woocommerce_add_payment_method', 'kalium_woocommerce_myaccount_add_payment_method_heading' );
add_action( 'woocommerce_before_account_payment_methods', 'kalium_woocommerce_myaccount_add_payment_method_heading' );
add_action( 'before_woocommerce_pay', 'kalium_woocommerce_myaccount_form_pay_heading' );

/**
 * Downloads table product image.
 */
add_action( 'woocommerce_account_downloads_column_download-product', 'kalium_woocommerce_downloads_column_product_name' );

/**
 * Order thank you page.
 */
add_action( 'woocommerce_before_thankyou', 'kalium_woocommerce_order_thankyou_wrapper_start', 1 );
add_action( 'woocommerce_thankyou', 'kalium_woocommerce_order_thankyou_wrapper_end', 1000 );

/**
 * Checkout steps breadcrumb.
 */
add_action( 'kalium_wrapper_start', 'kalium_woocommerce_checkout_steps', 11 );

/**
 * Disable YITH wishlist style/scripts deps.
 *
 * @param array $deps
 *
 * @return array
 */
add_filter( 'yith_wcwl_main_style_deps', '__return_empty_array' );
add_filter( 'yith_wcwl_main_script_deps', '__return_empty_array' );

/**
 * Mini cart (cart drawer).
 */
add_action( 'kalium_woocommerce_mini_cart_empty', 'kalium_woocommerce_mini_cart_close' );
add_action( 'kalium_woocommerce_mini_cart_empty', 'kalium_woocommerce_mini_cart_empty_message', 20 );

add_action( 'kalium_woocommerce_mini_cart_header', 'kalium_woocommerce_mini_cart_title' );
add_action( 'kalium_woocommerce_mini_cart_header', 'kalium_woocommerce_mini_cart_close', 20 );

add_action( 'kalium_woocommerce_mini_cart_contents', 'kalium_woocommerce_mini_cart_notices' );
add_action( 'kalium_woocommerce_mini_cart_contents', 'kalium_woocommerce_mini_cart_contents', 20 );

add_action( 'kalium_woocommerce_mini_cart_footer', 'kalium_woocommerce_mini_cart_subtotal', 20 );
add_action( 'kalium_woocommerce_mini_cart_footer', 'kalium_woocommerce_mini_cart_buttons', 30 );
add_action( 'kalium_woocommerce_mini_cart_footer', 'kalium_woocommerce_mini_cart_nonce', 30 );

/**
 * Free shipping progress bar.
 */
add_action( 'kalium_woocommerce_mini_cart_footer', 'kalium_woocommerce_mini_cart_free_shipping_bar' );
add_action( 'woocommerce_before_cart_table', 'kalium_woocommerce_cart_free_shipping_bar' );
add_action( 'woocommerce_checkout_billing', 'kalium_woocommerce_checkout_free_shipping_bar' );
add_action( 'woocommerce_single_product_summary', 'kalium_woocommerce_single_product_free_shipping_bar', 28 );
