<?php
/**
 * Kalium WordPress Theme
 *
 * Choose page builder view.
 *
 * @var string $content_pack_id
 * @var string[] $builder_types
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 */
use Kalium\Importer\Importer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$default_content_pack = Importer::instance()->get_content_pack( $builder_types[0] . '-' . $content_pack_id );

?>
<div class="kalium-sites__content-pack-view">
    <div class="kalium-sites__builder-types-title">
        <h1>Select a Page Builder for <?php echo esc_html( $default_content_pack->get_name() ); ?></h1>
        <p>Please choose your preferred page builder for this starter site.</p>
    </div>
    <div class="kalium-sites__content-pack-view-import-body">
        <ul class="kalium-sites__builder-types">
            <?php foreach ( $builder_types as $builder_type ) : ?>
                <?php
                    $content_pack = Importer::instance()->get_content_pack( $builder_type . '-' . $content_pack_id );
                    $install_link = $content_pack->get_link( 'install' );
                    $is_selected = ! isset( $is_selected );

                    $classes = [
                        'kalium-sites__builder-type',
                        $is_selected ? 'kalium-sites__builder-type--selected' : '',
                    ];
                ?>
                <li <?php kalium_class_attr( $classes ); ?>>
                    <label>
                        <button type="button" class="button" data-content-pack-id="<?php echo esc_attr( $content_pack->get_base_id() ); ?>" data-content-pack-url="<?php echo esc_attr( $install_link ); ?>">
                            <img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/starter-sites/page-builder-' . $builder_type . '.svg' ) ); ?>" />
                        </button>
                        <?php echo esc_html( Importer::instance()->get_type_title( $builder_type ) ); ?>
                    </label>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <div class="kalium-sites__content-pack-view-footer kalium-sites__content-pack-view-footer--align-right">
        <div class="kalium-sites__content-pack-view-footer-buttons">
            <button type="button" class="button button-primary choose-builder-continue">Next Step</button>
        </div>
    </div>
</div>