<?php
/**
 * Kalium WordPress Theme
 *
 * Starter sites page.
 *
 * @var Kalium\Importer\Content_Pack[] $installed
 * @var Kalium\Importer\Content_Pack[] $starter_sites
 *
 * @author  Laborator
 * @link    https://kaliumtheme.com
 */
use Kalium\Importer\Importer;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$grouped_starter_sites = Importer::instance()->group_starter_sites_by_builder( $starter_sites );

/**
 * List installed starter sites.
 */
if ( ! empty( $installed ) ) :
	?>
	<ul class="kalium-sites__installed-sites row">
		<?php
		foreach ( $installed as $content_pack ) :
			$import_instance  = $content_pack->get_import_instance();
			$imported_content = wp_list_pluck( $import_instance->get_imported_content_type(), 'name' );

			?>
			<li class="col col-12">

				<div class="kalium-sites__installed-content-pack-entry" data-importer-site-id="<?php echo esc_attr( $content_pack->get_base_id() ); ?>">
					<div class="kalium-sites__installed-content-pack-entry-thumbnail">
						<div class="kalium-sites__installed-content-pack-entry-thumbnail-container">
							<img src="<?php echo esc_url( $content_pack->get_thumbnail_url() ); ?>" class="kalium-sites__content-pack-icon-thumb" width="570" height="740" alt="<?php echo esc_attr( $content_pack->get_base_id() ); ?>-thumbnail"/>
							<img src="<?php echo esc_url( kalium()->assets_url( 'admin/images/starter-sites/' . $content_pack->get_type() . '.png' ) ); ?>" class="kalium-sites__content-pack-icon-type" width="24" height="24" alt="<?php echo esc_attr( $content_pack->get_type() ); ?>" />
						</div>
					</div>

					<div class="kalium-sites__installed-content-pack-entry-details">
						<h3>Installed Starter Site: <?php echo esc_html( $content_pack->get_name() ); ?></h3>
						<p>
							<strong>Imported:</strong>
							<?php echo esc_html( implode( ', ', $imported_content ) ); ?>
						</p>

						<div class="kalium-sites__installed-content-pack-entry-buttons">
							<button type="button" data-importer-link="<?php echo esc_url( $content_pack->get_link( 'uninstall' ) ); ?>" class="button button-uninstall kalium-sites__content-pack-entry-link">Uninstall</button>
						</div>
					</div>

				</div>

			</li>
			<?php
		endforeach;
		?>
	</ul>
	<?php

endif;
?>

<ul class="kalium-sites">
	<?php
	/**
	 * List starter sites.
	 */
	foreach ( $grouped_starter_sites as $sites_group ) :
		$content_pack = reset( $sites_group );

		$import_title   = 'Import';
		$import_link    = $content_pack->get_link( 'import' );
		$single_builder = 1 === count( $sites_group );

		// Builder types
		$builder_types = array_map(
			static function ( $content_pack ) {
				return $content_pack->get_type();
			},
			$sites_group
		);

		$builders = array_map( [ Importer::instance(), 'get_type_title' ], $builder_types );

		// For multiple builder types, use the builder selection page
		if ( ! $single_builder ) {
			$import_link = $content_pack->get_link( 'choose-page-builder' );

		}

		$import_button_classes = [
			'button',
			'button-primary',
			'kalium-sites__content-pack-entry-link',
		];

		?>
		<li>
			<div class="kalium-sites__content-pack-entry kalium-dashboard__card" data-importer-site-id="<?php echo esc_attr( $single_builder ? $content_pack->get_base_id() : $content_pack->get_id() ); ?>" data-builder-types="<?php echo esc_attr( implode( ',', $builder_types ) ); ?>">
				<a href="" data-importer-link="<?php echo esc_url( $import_link ); ?>" class="kalium-sites__content-pack-entry-link kalium-sites__content-pack-entry-image">
					<img src="<?php echo esc_url( $content_pack->get_thumbnail_url() ); ?>" loading="lazy" alt="<?php echo esc_attr( $content_pack->get_base_id() . '-thumb' ); ?>" />
				</a>

				<div class="kalium-sites__content-pack-entry-details">
					<h3>
						<?php echo esc_html( $content_pack->get_name() ); ?>
						<small><?php echo esc_html( implode( ' &bull; ', $builders ) ); ?></small>
					</h3>

					<div class="kalium-sites__content-pack-entry-details-buttons wp-clearfix">
						<button type="button" data-importer-link="<?php echo esc_url( $import_link ); ?>" title="Starter Site &raquo; <?php echo esc_attr( $content_pack->get_name() ); ?>" <?php kalium_class_attr( $import_button_classes ); ?>><?php echo esc_html( $import_title ); ?></button>
						<a href="<?php echo esc_url( $content_pack->get_preview_url() ); ?>" target="_blank" class="button button-secondary button-external" title="Preview this starter site">Preview</a>
					</div>
				</div>

				<?php if ( ! empty( $badges = $content_pack->get_badges() ) ) : ?>
					<div class="kalium-sites__content-pack-entry-badges">
						<?php foreach ( $content_pack->get_badges() as $badge ) : ?>
							<span class="badge badge--<?php echo esc_attr( $badge['type'] ); ?>"><?php echo esc_html( $badge['text'] ); ?></span>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>
			</div>
		</li>
		<?php

	endforeach;
	?>
</ul>
