<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$footer_sidebars = array_reduce(
	[
		[
			'id'   => 'footer_sidebar',
			'name' => 'Widget Area 1',
		],
		[
			'id'   => 'footer_sidebar_2',
			'name' => 'Widget Area 2',
		],
		[
			'id'   => 'footer_sidebar_3',
			'name' => 'Widget Area 3',
		],
		[
			'id'   => 'footer_sidebar_4',
			'name' => 'Widget Area 4',
		],
		[
			'id'   => 'footer_sidebar_5',
			'name' => 'Widget Area 5',
		],
		[
			'id'   => 'footer_sidebar_6',
			'name' => 'Widget Area 6',
		],
	],
	function ( $arr, $sidebar ) {
		$id   = $sidebar['id'];
		$name = $sidebar['name'];

		$arr[ 'footer_sidebar_' . $id ] = [
			'extend' => [
				'element'           => 'footer_sidebar',
				'title'             => $name,
				'max_instances'     => 1,
				'remove_attributes' => [
					'sidebar_id',
				],
			],
			'global' => false,
		];

		return $arr;
	},
	[]
);

return [
	// Options
	'add_label'          => 'Add Footer Row',

	// Elements
	'elements'           => array_merge(
		[
			'footer_container_row' => [
				'extend' => [
					'extend_attributes' => [
						'bg_color'       => [
							'default' => kalium_color_reference( 'theme_colors_footer.background' ),
						],
						'text_color'     => [
							'default' => kalium_color_reference( 'theme_colors_footer.text' ),
						],
						'headings_color' => [
							'default' => kalium_color_reference( 'theme_colors_footer.headings' ),
						],
						'link_color'     => [
							'default' => [
								'normal' => kalium_color_reference( 'theme_colors_footer.link' ),
								'hover'  => kalium_color_reference( 'theme_colors_footer.link-hover' ),
							],
						],
						'gutter_y'       => [
							'default' => [
								'tablet' => '20px',
							],
						],
					],
					'add_label'         => 'Add Column',
				],
				'global' => false,
			],
			'column'               => [
				'extend' => [
					'allowed_child_elements' => array_keys( $footer_sidebars ),
					'add_label'              => 'Add Widget Area',
				],
				'global' => false,
			],
		],
		$footer_sidebars,
	),

	// Element variations
	'element_variations' => array_map(
		static function ( $variation ) {
			return array_merge(
				$variation,
				[
					'content' => file_get_contents( __DIR__ . '/element-variations/' . $variation['content'] . '.json' ),
					'icon'    => kalium_get_svg_file( __DIR__ . '/images/' . $variation['content'] . '.svg' ),
				]
			);
		},
		[
			[
				'category' => '1 Column',
				'content'  => 'footer-1-col-1',
			],
			[
				'category' => '2 Columns',
				'content'  => 'footer-2-col-1',
			],
			[
				'content' => 'footer-2-col-2',
			],
			[
				'content' => 'footer-2-col-3',
			],
			[
				'category' => '3 Columns',
				'content'  => 'footer-3-col-1',
			],
			[
				'content' => 'footer-3-col-2',
			],
			[
				'content' => 'footer-3-col-3',
			],
			[
				'content' => 'footer-3-col-4',
			],
			[
				'content' => 'footer-3-col-5',
			],
			[
				'category' => '4 Columns',
				'content'  => 'footer-4-col-1',
			],
			[
				'content' => 'footer-4-col-2',
			],
			[
				'content' => 'footer-4-col-3',
			],
			[
				'content' => 'footer-4-col-4',
			],
			[
				'category' => '5 Columns',
				'content'  => 'footer-5-col-1',
			],
			[
				'content' => 'footer-5-col-2',
			],
			[
				'content' => 'footer-5-col-3',
			],
			[
				'content' => 'footer-5-col-4',
			],
			[
				'category' => '6 Columns',
				'content'  => 'footer-6-col-1',
			],
		]
	),

	// Default content
	'default_content'    => [
		[
			'name'       => 'footer_container_row',
			'attributes' => [],
			'visible'    => true,
			'elements'   => [
				[
					'name'       => 'column',
					'attributes' => [
						[
							'name'  => 'columns',
							'value' => [
								'desktop' => 6,
								'tablet'  => 6,
								'mobile'  => 12,
							],
						],
					],
					'visible'    => true,
					'elements'   => [
						[
							'name'       => 'footer_sidebar_footer_sidebar',
							'attributes' => [],
							'visible'    => true,
						],
					],
				],
				[
					'name'       => 'column',
					'attributes' => [
						[
							'name'  => 'columns',
							'value' => [
								'desktop' => 6,
								'tablet'  => 6,
								'mobile'  => 12,
							],
						],
						[
							'name'  => 'horizontal_align',
							'value' => 'end',
						],
					],
					'visible'    => true,
					'elements'   => [
						[
							'name'       => 'footer_sidebar_footer_sidebar_2',
							'attributes' => [],
							'visible'    => true,
						],
					],
				],
			],
		],
	],
];
