<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$images_url = kalium()->file_url( str_replace( kalium()->locate_file(), '', __DIR__ . '/images' ) );

return [
	// Mode
	'mode'        => 'advanced',

	// Elements
	'elements'    => [
		'woocommerce_product_row',
		'woocommerce_product_column' => [
			'global' => false,
		],
		'woocommerce_product_title',
		'woocommerce_product_images',
		'woocommerce_product_price',
		'woocommerce_product_add_to_cart',
		'woocommerce_product_sale_badge',
		'woocommerce_product_description',
		'woocommerce_product_category',
		'woocommerce_product_attribute',
		'woocommerce_product_wishlist',
		'woocommerce_product_swap_on_hover',
		'woocommerce_product_hover_block',
	],

	// Templates
	'templates'   => [
		[
			'id'       => 'lisbon',
			'name'     => 'Lisbon',
			'icon'     => $images_url . '/lisbon.svg',
			'template' => __DIR__ . '/templates/lisbon.json',
		],
		[
			'id'       => 'oslo',
			'name'     => 'Oslo',
			'icon'     => $images_url . '/oslo.svg',
			'template' => __DIR__ . '/templates/oslo.json',
		],
		[
			'id'       => 'helsinki',
			'name'     => 'Helsinki',
			'icon'     => $images_url . '/helsinki.svg',
			'template' => __DIR__ . '/templates/helsinki.json',
		],
		[
			'id'       => 'tallinn',
			'name'     => 'Tallinn',
			'icon'     => $images_url . '/tallinn.svg',
			'template' => __DIR__ . '/templates/tallinn.json',
		],
		[
			'id'       => 'pristina',
			'name'     => 'Pristina',
			'icon'     => $images_url . '/pristina.svg',
			'template' => __DIR__ . '/templates/pristina.json',
		],
	],

	// Tabs
	'tabs'        => [
		'templates'      => [
			'content_type' => 'templates',
			'title'        => 'Templates',
			'description'  => '<h3>List Product Card</h3><p>Select any of the pre-made templates that come with the theme or edit them.</p>',
			'active'       => true,
		],
		'user-templates' => [
			'content_type' => 'user-templates',
			'title'        => 'User Templates',
			'description'  => '<h3>User Templates</h3><p>Create your own list product layout or select any of the pre-made templates.<br /><br /> <small><strong>Please Note:</strong> Template modifications or updates will not take effect unless you publish the changes.</small></p>',
		],
	],

	// Preview URL
	'preview_url' => kalium()->is->woocommerce_active() ? add_query_arg( 'switch_columns', 'list', wc_get_page_permalink( 'shop' ) ) : null,
];
