<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$disabled_message_text = 'plugin should be installed and activated in order for this element to work.';

return [
	// Elements
	'elements'        => [
		'legacy_header_content_top'             => [
			'extend' => [
				'element'           => 'legacy_header_row',
				'title'             => 'Main Content',
				'extend_attributes' => [
					'align'          => [
						'choices' => [
							'left'   => [
								'label' => 'Start',
								'icon'  => 'justifyLeft',
							],
							'center' => [
								'label' => 'Center',
								'icon'  => 'justifyCenter',
							],
							'right'  => [
								'label' => 'End',
								'icon'  => 'justifyRight',
							],
						],
						'buttons' => [
							'icon_size' => 18,
						],
					],
					'align_vertical' => [
						'type'    => 'radio',
						'title'   => 'Vertical Align',
						'reset'   => true,
						'choices' => [
							'top'    => [
								'label' => 'Top',
								'icon'  => 'verticalAlignTop',
							],
							'center' => [
								'label' => 'Center',
								'icon'  => 'verticalAlignCenter',
							],
							'bottom' => [
								'label' => 'Bottom',
								'icon'  => 'verticalAlignBottom',
							],
						],
						'buttons' => [
							'icon_size' => 18,
						],
					],
				],
			],
		],
		'legacy_header_content_bottom'          => [
			'extend' => [
				'element'           => 'legacy_header_row',
				'title'             => 'Footer Content',
				'extend_attributes' => [
					'align' => [
						'choices' => [
							'left'   => [
								'icon' => 'justifyLeft',
							],
							'center' => [
								'icon' => 'justifyCenter',
							],
							'right'  => [
								'icon' => 'justifyRight',
							],
						],
					],
				],
			],
		],
		'legacy_header_menu_mobile'             => [
			'extend' => [
				'extend_attributes' => [
					'menu_item_spacing' => [
						'initial_position' => 10,
						'placeholder'      => 10,
					],
				],
				'remove_attributes' => [
					'mobile_menu_toggle',
					'mobile_menu_toggle_position',
					'visible_on',
				],
			],
		],
		'legacy_header_search_input'            => [
			'extend' => [
				'remove_attributes' => [
					'visible_on',
				],
			],
		],
		'legacy_header_social_icons'            => [
			'extend' => [
				'remove_attributes' => [
					'visible_on',
				],
			],
		],
		'legacy_header_raw_text'                => [
			'extend' => [
				'remove_attributes' => [
					'visible_on',
				],
			],
		],
		'legacy_header_button'                  => [
			'extend' => [
				'remove_attributes' => [
					'visible_on',
				],
			],
		],
		'legacy_header_woocommerce_cart_totals' => [
			'extend' => [
				'enabled'           => kalium()->is->woocommerce_active(),
				'disabled_message'  => 'WooCommerce ' . $disabled_message_text,
				'remove_attributes' => [
					'visible_on',
				],
			],
		],
		'legacy_header_wpml_language_switcher'  => [
			'extend' => [
				'enabled'           => kalium()->is->wpml_active(),
				'disabled_message'  => 'WPML ' . $disabled_message_text,
				'remove_attributes' => [
					'visible_on',
				],
			],
		],
	],

	// Regions
	'regions'         => [
		'legacy_header_content_top',
		'legacy_header_content_bottom',
	],

	// Default content
	'default_content' => [
		[
			'name'     => 'legacy_header_content_top',
			'elements' => [
				[ 'name' => 'legacy_header_menu_mobile' ],
			],
		],
	],

	// Show attributes on Add Element
	'show_attributes' => true,
];
