<?php
/**
 * Content Type definition.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

$images_url = kalium()->file_url( str_replace( kalium()->locate_file(), '', __DIR__ . '/images' ) );

return [
	// Mode
	'mode'             => 'advanced',

	// Elements
	'elements'         => [
		'woocommerce_product_row',
		'woocommerce_product_column' => [
			'global' => false,
		],
		'woocommerce_product_title',
		'woocommerce_product_images',
		'woocommerce_product_price',
		'woocommerce_product_add_to_cart',
		'woocommerce_product_sale_badge',
		'woocommerce_product_description',
		'woocommerce_product_category',
		'woocommerce_product_attribute',
		'woocommerce_product_wishlist',
		'woocommerce_product_swap_on_hover',
		'woocommerce_product_hover_block',
		'text',
	],

	// Templates
	'templates'        => [
		[
			'id'       => 'london',
			'name'     => 'London',
			'icon'     => $images_url . '/london.svg',
			'template' => __DIR__ . '/templates/london.json',
		],
		[
			'id'       => 'paris',
			'name'     => 'Paris',
			'icon'     => $images_url . '/paris.svg',
			'template' => __DIR__ . '/templates/paris.json',
		],
		[
			'id'       => 'berlin',
			'name'     => 'Berlin',
			'icon'     => $images_url . '/berlin.svg',
			'template' => __DIR__ . '/templates/berlin.json',
		],
		[
			'id'       => 'madrid',
			'name'     => 'Madrid',
			'icon'     => $images_url . '/madrid.svg',
			'template' => __DIR__ . '/templates/madrid.json',
		],
		[
			'id'       => 'rome',
			'name'     => 'Rome',
			'icon'     => $images_url . '/rome.svg',
			'template' => __DIR__ . '/templates/rome.json',
		],
		[
			'id'       => 'istanbul',
			'name'     => 'Istanbul',
			'icon'     => $images_url . '/istanbul.svg',
			'template' => __DIR__ . '/templates/istanbul.json',
		],
		[
			'id'       => 'brussels',
			'name'     => 'Brussels',
			'icon'     => $images_url . '/brussels.svg',
			'template' => __DIR__ . '/templates/brussels.json',
		],
		[
			'id'       => 'vienna',
			'name'     => 'Vienna',
			'icon'     => $images_url . '/vienna.svg',
			'template' => __DIR__ . '/templates/vienna.json',
		],
		[
			'id'       => 'stockholm',
			'name'     => 'Stockholm',
			'icon'     => $images_url . '/stockholm.svg',
			'template' => __DIR__ . '/templates/stockholm.json',
		],
		[
			'id'       => 'prague',
			'name'     => 'Prague',
			'icon'     => $images_url . '/prague.svg',
			'template' => __DIR__ . '/templates/prague.json',
		],
		[
			'id'       => 'copenhagen',
			'name'     => 'Copenhagen',
			'icon'     => $images_url . '/copenhagen.svg',
			'template' => __DIR__ . '/templates/copenhagen.json',
		],
		[
			'id'       => 'athens',
			'name'     => 'Athens',
			'icon'     => $images_url . '/athens.svg',
			'template' => __DIR__ . '/templates/athens.json',
		],
	],

	// Template columns
	'template_columns' => 3,

	// Tabs
	'tabs'             => [
		'templates'      => [
			'content_type' => 'templates',
			'title'        => 'Templates',
			'description'  => '<h3>Templates Library</h3><p>Select any of the pre-made templates that come with the theme or edit them.</p>',
			'active'       => true,
		],
		'user-templates' => [
			'content_type' => 'user-templates',
			'title'        => 'User Templates',
			'description'  => '<h3>User Templates</h3><p>Create your own product layout or select any of the pre-made templates.<br /><br /> <small><strong>Please Note:</strong> Template modifications or updates will not take effect unless you publish the changes.</small></p>',
		],
	],

	// Preview URL
	'preview_url'      => kalium()->is->woocommerce_active() ? wc_get_page_permalink( 'shop' ) : null,
];
