<?php
/**
 * Row element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute_Set;
use Laborator_Builder\Attribute_Sets\Content_Visibility_Set;
use Laborator_Builder\Attribute_Sets\Content_Flex_Alignment_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;

class Row extends Element {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'row';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Row';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'row';

	/**
	 * Child container.
	 *
	 * @var bool
	 */
	public static $child_container = true;

	/**
	 * Allowed child elements.
	 *
	 * @var bool
	 */
	public static $allowed_child_elements = [
		'column',
	];

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Content_Visibility_Set::class,
				Content_Flex_Alignment_Set::class,
				Advanced_Layout_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
			]
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		if ( $this instanceof Container_Row ) {
			return parent::get_dom_class();
		}

		return array_merge( parent::get_dom_class(), $this->get_row_classes() );
	}

	/**
	 * Get row classes.
	 *
	 * @return array
	 */
	public function get_row_classes() {
		$classes = [
			'row',
		];

		// Add flex alignment classes
		$flex_alignment = new Content_Flex_Alignment_Set( $this );

		return array_merge( $classes, $flex_alignment->get_dom_class() );
	}
}

// Register element
\Laborator_Builder::register_element_type( Row::class );
