<?php
/**
 * Sidebar widget element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Element;

class Sidebar extends Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'sidebar';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Sidebar';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'sidebar';

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				// Advanced_Custom_CSS_Set::class,
			]
		);
	}

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		global $wp_registered_sidebars;

		$sidebars = [];

		foreach ( $wp_registered_sidebars as $sidebar ) {
			$sidebars[ $sidebar['id'] ] = $sidebar['name'];
		}

		return array_merge(
			parent::create_attributes(),
			[
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::TAB_CONTENT,
					[
						Attribute::create(
							'sidebar_id',
							[
								'type'         => 'select',
								'title'        => 'Sidebar',
								'choices'      => $sidebars,
								'inline_label' => true,
							]
						),
						Attribute::create(
							'widgets_per_row',
							[
								'type'         => 'quantity',
								'title'        => 'Widgets Per Row',
								'inline_label' => true,
								'responsive'   => true,
								'min'          => 1,
								'max'          => 12,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$classes = [];

		// Widgets per row
		$widgets_per_row = $this->get_attribute_value( 'widgets_per_row' );

		if ( false === kalium_is_empty_responsive( $widgets_per_row ) ) {
			$classes = array_merge( $classes, [ 'row' ], kalium_responsive_classname_infix( $widgets_per_row, 'row-cols' ) );
		}

		return array_merge( parent::get_dom_class(), $classes );
	}


	/**
	 * Element content.
	 */
	public function element_content() {
		$sidebar_id = $this->get_attribute_value( 'sidebar_id' );

		dynamic_sidebar( $sidebar_id );
	}
}

// Register element
\Laborator_Builder::register_element_type( Sidebar::class );
