<?php
/**
 * Footer sidebar.
 */

namespace Laborator_Builder\Elements;

class Footer_Sidebar extends Sidebar {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'footer_sidebar';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'footer';

	/**
	 * Sidebar content.
	 */
	public function element_content() {
		$sidebar_id = preg_replace( '/^footer_sidebar_/', '', $this->get_name() );

		dynamic_sidebar( $sidebar_id );
	}
}

// Register element
\Laborator_Builder::register_element_type( Footer_Sidebar::class );
