<?php
/**
 * Legacy header base element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute;
use Laborator_Builder\Predefined_Attributes;

class Legacy_Header_Base_Element extends Element {

	/**
	 * Get base class.
	 *
	 * @return string
	 */
	public function get_base_class() {
		return 'lb-header-' . $this->get_name();
	}

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return [
			// Content / Content
			Attribute::tab_section(
				Attribute::TAB_CONTENT,
				Attribute::SECTION_CONTENT,
				[
					Attribute::create(
						'visible_on',
						[
							'type'         => 'checkbox',
							'title'        => 'Visible On',
							'inline_label' => true,
							'choices'      => [
								'desktop' => [
									'label' => 'Desktop',
									'icon'  => 'desktop',
								],
								'tablet'  => [
									'label' => 'Tablet',
									'icon'  => 'tablet',
								],
								'mobile'  => [
									'label' => 'Mobile',
									'icon'  => 'mobile',
								],
							],
							'buttons'      => [
								'icon_size' => 20,
							],
							'default'      => [ 'desktop', 'tablet', 'mobile' ],
							'order'        => 100,
						]
					),
				]
			),

			// Advanced / Custom CSS
			Attribute::tab_section(
				Attribute::TAB_CONTENT,
				Attribute::SECTION_CUSTOM_CSS,
				[
					Attribute::create(
						Predefined_Attributes::$CUSTOM_CSS,
						[
							'order' => 110,
						]
					),
				]
			),
		];
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$classes = [
			'header-block__item',
			'header-block__item--type-' . str_replace( '_', '-', str_replace( 'legacy_header_', '', $this->get_name() ) ),
		];

		// Visibility
		$devices    = [ 'desktop', 'tablet', 'mobile' ];
		$visible_on = $this->get_attribute_value( 'visible_on' );

		if ( is_array( $visible_on ) ) {
			foreach ( $devices as $device ) {
				if ( ! in_array( $device, $visible_on ) ) {
					$classes[] = 'header-block__item--hide-on-' . $device;
				}
			}
		}

		return array_merge( $classes, parent::get_dom_class() );
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		parent::generate_styles();

		// Custom CSS
		$this->add_custom_css( 'custom_css', $this->get_attribute( 'custom_css' ) );
	}
}
