<?php
/**
 * Date Time element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Date_Time extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_date_time';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Date and Time';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'postDate';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'date_format',
							[
								'type'        => 'text',
								'title'       => 'Date or Time Format',
								'placeholder' => get_option( 'date_format' ),
								'description' => 'See documentation for <a href="https://wordpress.org/support/article/formatting-date-and-time/" target="_blank" rel="noopener">date and time formatting</a>',
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$date_format = $this->get_attribute_value( 'date_format' );

		// Date format
		if ( empty( $date_format ) ) {
			$date_format = get_option( 'date_format' );
		}

		// Current date
		$date = function_exists( 'wp_date' ) ? wp_date( $date_format ) : date_i18n( $date_format );

		// DOM element attrs
		$date_element_attrs = [
			'class' => kalium_tokenize_list(
				[
					'date-time-widget',
				]
			),
		];

		kalium_render_element(
			[
				'tag_name'   => 'div',
				'attributes' => $date_element_attrs,
				'content'    => $date,
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Date_Time::class );
