<?php
/**
 * Menu element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Menu extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_menu';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Menu';

	/**
	 * Dynamic title.
	 *
	 * @var string
	 * @static
	 */
	// public static $dynamic_title = '{{ data.attributes.menu_id }}';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'menu';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'menu_id',
							[
								'type'         => 'select',
								'title'        => 'Menu',
								'inline_label' => true,
								'choices'      => array_merge(
									[
										[
											'value' => 'main-menu',
											'label' => '- Main Menu -',
										],
									],
									kalium_header_get_menu_choices()
								),
							]
						),
						Attribute::create(
							'submenu_dropdown_caret',
							[
								'type'         => 'toggle',
								'title'        => 'Submenu Arrow',
								'inline_label' => true,
								'default'      => true,
							]
						),
						Attribute::create(
							'mobile_menu_toggle',
							[
								'type'         => 'toggle',
								'title'        => 'Mobile Menu Trigger',
								'inline_label' => true,
								'default'      => true,
							]
						),
						Attribute::create(
							'mobile_menu_toggle_position',
							[
								'type'         => 'select',
								'title'        => 'Trigger Position',
								'inline_label' => true,
								'choices'      => [
									'current' => 'Current position',
									'start'   => 'Beginning of column',
									'end'     => 'End of column',
								],
								'default'      => 'end',
								'description'  => 'On mobile viewport set the menu trigger button position.',
								'dependency'   => [
									'mobile_menu_toggle' => true,
								],
							]
						),
					]
				),

				// Style / Spacing
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Spacing',
					[
						Attribute::create(
							'menu_item_spacing',
							[
								'type'             => 'range',
								'title'            => 'Menu Item Spacing',
								'reset'            => true,
								'units'            => kalium_get_default_units( 'box-size' ),
								'initial_position' => 30,
								'placeholder'      => 30,
								'min'              => 0,
								'max'              => 100,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		return array_merge(
			parent::get_dom_class(),
			[
				'header-block__item--standard-menu',
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$is_off_canvas_view = $this->get_option( 'off_canvas_view' );

		$menu_id    = $this->get_attribute_value( 'menu_id' );
		$menu_caret = $this->get_attribute_value( 'submenu_dropdown_caret' );

		// Classes
		$classes = [
			kalium_if_else( $is_off_canvas_view, 'list-nav-menu', 'standard-menu' ),
			kalium_get_link_style_class_by_context( 'standard-menu' ),
		];

		// CSS vars
		$menu_css_vars = [];

		// Item spacing
		$menu_item_spacing = kalium_to_unit_value( $this->get_attribute_value( 'menu_item_spacing' ) );

		if ( empty( $menu_item_spacing ) ) {
			$menu_item_spacing = kalium_get_theme_option( 'header_menu_item_spacing' );
		}

		if ( ! empty( $menu_item_spacing ) ) {
			$menu_css_vars['menu-item-spacing'] = $menu_css_vars['pill-menu-item-spacing'] = $menu_item_spacing;
		}

		// Menu args
		$menu_args = [
			'menu_depth' => $this->get_option( 'menu_depth' ),
			'sss'        => 1,
		];

		// Menu location or menu id to load
		if ( is_numeric( $menu_id ) ) {
			$menu_args['menu'] = $menu_id;
		} elseif ( is_string( $menu_id ) ) {
			$menu_args['theme_location'] = $menu_id;
		}

		// Submenu caret
		$menu_args['dropdown_toggle']      = $menu_caret;
		$menu_args['dropdown_submenu_alt'] = ! $is_off_canvas_view;

		// Style vars
		kalium_print_inline_style(
			[
				'selector' => '.' . $this->get_common_class() . ' .standard-menu',
				'vars'     => $menu_css_vars,
			]
		);

		// Menu
		kalium_render_element(
			[
				'tag_name'   => 'div',
				'attributes' => [
					'class' => kalium_tokenize_list( $classes ),
				],
				'content'    => kalium_nav_menu( $menu_args ),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Menu::class );
