<?php
/**
 * Legacy Header Row element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Row extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_row';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Row';

	/**
	 * Child container.
	 *
	 * @var bool
	 * @static
	 */
	public static $child_container = true;

	/**
	 * Maximum nesting level.
	 *
	 * @var int
	 * @static
	 */
	public static $max_nesting_level = 0;

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return [
			Attribute::create(
				'align',
				[
					'type'    => 'radio',
					'title'   => 'Content Align',
					'reset'   => true,
					'choices' => [
						'left'          => [
							'label' => 'Left',
							'icon'  => 'justifyLeft',
						],
						'center'        => [
							'label' => 'Center',
							'icon'  => 'justifyCenter',
						],
						'right'         => [
							'label' => 'Right',
							'icon'  => 'justifyRight',
						],
						'space-between' => [
							'label' => 'Space Between',
							'icon'  => 'justifySpaceBetween',
						],
					],
					'buttons' => [
						'icon_size' => 18,
					],
				]
			),
		];
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$classes = parent::get_dom_class();

		if ( $this->get_option( 'off_canvas_view' ) ) {
			$classes[] = 'header-row';

			if ( $align_horizontal = $this->get_attribute_value( 'align' ) ) {
				$classes[] = 'header-row--justify-' . $align_horizontal;
			}

			if ( $align_vertical = $this->get_attribute_value( 'align_vertical' ) ) {
				$classes[] = 'header-row--align-' . $align_vertical;
			}
		}

		return $classes;
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Row::class );
