<?php
/**
 * Social Icons element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_Social_Icons extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_social_icons';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Social Icons';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'share';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'icon',
							[
								'type'         => 'toggle',
								'title'        => 'Icon',
								'inline_label' => true,
								'default'      => true,
							]
						),
						Attribute::create(
							'label',
							[
								'type'         => 'toggle',
								'title'        => 'Label',
								'inline_label' => true,
							]
						),
						Attribute::create(
							'spacing',
							[
								'type'             => 'range',
								'title'            => 'Spacing',
								'reset'            => true,
								'placeholder'      => 15,
								'units'            => kalium_get_default_units( 'box-size' ),
								'initial_position' => 15,
								'min'              => 0,
								'max'              => 80,
							]
						),
						Attribute::create(
							'size',
							[
								'type'             => 'range',
								'title'            => 'Size',
								'reset'            => true,
								'placeholder'      => 16,
								'units'            => kalium_get_default_units( 'font-size' ),
								'initial_position' => 16,
								'min'              => 0,
								'max'              => 80,
							]
						),
						Attribute::create(
							'shape_type',
							[
								'type'    => 'radio',
								'title'   => 'Shape Type',
								'choices' => [
									'none'    => 'None',
									'rounded' => 'Rounded',
									'square'  => 'Square',
									'custom'  => 'Custom',
								],
								'buttons' => true,
							]
						),
						Attribute::create(
							'shape_radius',
							[
								'type'         => 'text',
								'title'        => 'Shape Radius',
								'inline_label' => true,
								'units'        => kalium_get_default_units( 'box-size' ),
								'dependency'   => [
									'shape_type' => 'custom',
								],
							]
						),
						Attribute::create(
							'shape_fill',
							[
								'type'         => 'radio',
								'title'        => 'Shape Fill',
								'inline_label' => true,
								'choices'      => [
									'solid'   => 'Solid',
									'outline' => 'Outline',
								],
								'buttons'      => true,
								'dependency'   => [
									'shape_type' => [
										'value'   => 'none',
										'compare' => '!=',
									],
								],
							]
						),
					]
				),
				// Content / Links
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					'Links',
					[
						Attribute::create(
							'new_tab',
							[
								'type'         => 'toggle',
								'title'        => 'Open in New Tab',
								'inline_label' => true,
								'reset'        => true,
								'default'      => true,
							]
						),
						Attribute::create(
							'no_follow',
							[
								'type'         => 'toggle',
								'title'        => 'Nofollow',
								'inline_label' => true,
								'reset'        => true,
								'description'  => 'Sets rel attribute to "nofollow" to social links. <a href="https://ahrefs.com/blog/nofollow-links/" target="_blank" rel="noopener nofolllow">Learn more</a>',
							]
						),
					]
				),

				// Content / Color
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Color',
					[
						// Color & Color Hover
						Attribute::create(
							'color',
							[
								'type'    => 'radio',
								'title'   => 'Color',
								'choices' => [
									'inherit' => 'Inherit',
									'brand'   => 'Brand',
									'custom'  => 'Custom',
								],
								'buttons' => true,
							]
						),
						Attribute::create(
							'color_custom',
							[
								'type'         => 'color',
								'title'        => 'Custom Color',
								'inline_label' => true,
								'dependency'   => [
									'color' => 'custom',
								],
							]
						),
						Attribute::create(
							'color_hover',
							[
								'type'    => 'radio',
								'title'   => 'Hover Color',
								'choices' => [
									'inherit' => 'Inherit',
									'brand'   => 'Brand',
									'custom'  => 'Custom',
								],
								'buttons' => true,
							]
						),
						Attribute::create(
							'color_hover_custom',
							[
								'type'         => 'color',
								'title'        => 'Custom Hover Color',
								'inline_label' => true,
								'dependency'   => [
									'color_hover' => 'custom',
								],
							]
						),
					]
				),

				// Content / Label Color
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Label Color',
					[
						// Label Color & Label Hover Color
						Attribute::create(
							'label_color',
							[
								'type'       => 'radio',
								'title'      => 'Label Color',
								'choices'    => [
									'inherit' => 'Inherit',
									'brand'   => 'Brand',
									'custom'  => 'Custom',
								],
								'buttons'    => true,
								'dependency' => [
									'label' => true,
								],
							]
						),
						Attribute::create(
							'label_color_custom',
							[
								'type'         => 'color',
								'title'        => 'Label Custom Color',
								'inline_label' => true,
								'dependency'   => [
									'label'       => true,
									'label_color' => 'custom',
								],
							]
						),
						Attribute::create(
							'label_color_hover',
							[
								'type'       => 'radio',
								'title'      => 'Label Hover Color',
								'choices'    => [
									'inherit' => 'Inherit',
									'brand'   => 'Brand',
									'custom'  => 'Custom',
								],
								'buttons'    => true,
								'dependency' => [
									'label' => true,
								],
							]
						),
						Attribute::create(
							'label_color_hover_custom',
							[
								'type'         => 'color',
								'title'        => 'Custom Label Hover Color',
								'inline_label' => true,
								'dependency'   => [
									'label'             => true,
									'label_color_hover' => 'custom',
								],
							]
						),
					]
				),

				// Content / Shape Color
				Attribute::tab_section(
					Attribute::TAB_STYLE,
					'Shape Color',
					[
						// Background & Background Hover
						Attribute::create(
							'background',
							[
								'type'       => 'radio',
								'title'      => 'Background',
								'choices'    => [
									'inherit' => 'Inherit',
									'brand'   => 'Brand',
									'custom'  => 'Custom',
								],
								'buttons'    => true,
								'dependency' => [
									'shape_type' => [
										'value'   => 'none',
										'compare' => '!=',
									],
								],
							]
						),
						Attribute::create(
							'background_custom',
							[
								'type'         => 'color',
								'title'        => 'Custom Background',
								'inline_label' => true,
								'dependency'   => [
									'shape_type' => [
										'value'   => 'none',
										'compare' => '!=',
									],
									'background' => 'custom',
								],
							]
						),
						Attribute::create(
							'background_hover',
							[
								'type'       => 'radio',
								'title'      => 'Hover Background',
								'choices'    => [
									'inherit' => 'Inherit',
									'brand'   => 'Brand',
									'custom'  => 'Custom',
								],
								'buttons'    => true,
								'dependency' => [
									'shape_type' => [
										'value'   => 'none',
										'compare' => '!=',
									],
								],
							]
						),
						Attribute::create(
							'background_hover_custom',
							[
								'type'         => 'color',
								'title'        => 'Custom Hover Background',
								'inline_label' => true,
								'dependency'   => [
									'shape_type'       => [
										'value'   => 'none',
										'compare' => '!=',
									],
									'background_hover' => 'custom',
								],
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		kalium_social_networks(
			[
				//
				// General
				//

				// Content
				'icon'                     => $this->get_attribute_value( 'icon' ),
				'label'                    => $this->get_attribute_value( 'label' ),

				// Icon shape
				'shape_type'               => $this->get_attribute_value( 'shape_type' ),
				'shape_fill'               => $this->get_attribute_value( 'shape_fill' ),
				'shape_radius'             => $this->get_attribute_value( 'shape_radius' ),

				// Link
				'new_tab'                  => $this->get_attribute_value( 'new_tab' ),
				'no_follow'                => $this->get_attribute_value( 'no_follow' ),

				// Other
				'spacing'                  => kalium_get_multi_numeric_prop( $this->get_attribute_value( 'spacing' ), 'size' ),
				'size'                     => kalium_get_multi_numeric_prop( $this->get_attribute_value( 'size' ), 'size' ),

				//
				// Style
				//

				// Icon color
				'color'                    => $this->get_attribute_value( 'color' ),
				'color_custom'             => $this->get_attribute_value( 'color_custom' ),
				'color_hover'              => $this->get_attribute_value( 'color_hover' ),
				'color_hover_custom'       => $this->get_attribute_value( 'color_hover_custom' ),

				// Label color
				'label_color'              => $this->get_attribute_value( 'label_color' ),
				'label_color_custom'       => $this->get_attribute_value( 'label_color_custom' ),
				'label_hover_color'        => $this->get_attribute_value( 'label_color_hover' ),
				'label_hover_color_custom' => $this->get_attribute_value( 'label_color_hover_custom' ),

				// Icon Background
				'background'               => $this->get_attribute_value( 'background' ),
				'background_custom'        => $this->get_attribute_value( 'background_custom' ),
				'background_hover'         => $this->get_attribute_value( 'background_hover' ),
				'background_hover_custom'  => $this->get_attribute_value( 'background_hover_custom' ),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_Social_Icons::class );
