<?php
/**
 * WooCommerce Cart Totals element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_WooCommerce_Cart_Totals extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_woocommerce_cart_totals';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Cart Totals';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'cartTotals';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'total_price',
							[
								'type'         => 'select',
								'title'        => 'Total Price',
								'inline_label' => true,
								'choices'      => [
									'cart-total'        => 'Cart total',
									'cart-subtotal'     => 'Cart subtotal',
									'cart-total-ex-tax' => 'Cart total excl. taxes',
								],
							]
						),
						Attribute::create(
							'text_before',
							[
								'type'         => 'text',
								'title'        => 'Prefix Text',
								'inline_label' => true,
								'placeholder'  => 'e.g. Totals:',
							]
						),
						Attribute::create(
							'hide_empty',
							[
								'type'         => 'toggle',
								'title'        => 'Hide Empty Cart',
								'inline_label' => true,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		if ( ! kalium()->is->woocommerce_active() ) {
			return;
		}

		$total_price = $this->get_attribute_value( 'total_price' );
		$text_before = $this->get_attribute_value( 'text_before' );
		$hide_empty  = $this->get_attribute_value( 'hide_empty' );

		kalium_woocommerce_cart_totals_widget(
			[
				'total_price' => $total_price,
				'text_before' => $text_before,
				'hide_empty'  => $hide_empty,
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_WooCommerce_Cart_Totals::class );
