<?php
/**
 * WooCommerce Mini Cart element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_WooCommerce_Mini_Cart extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_woocommerce_mini_cart';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'Cart';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'miniCart';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'icon',
							[
								'type'    => 'radio',
								'title'   => 'Icon',
								'choices' => [
									'icon-1' => [
										'icon' => 'kalium-icon-shopping-bag',
									],
									'icon-2' => [
										'icon' => 'kalium-icon-shopping-cart',
									],
									'icon-3' => [
										'icon' => 'kalium-icon-shopping-basket',
									],
									'none'   => [
										'label' => 'None',
									],
								],
								'buttons' => [
									'icon_size' => 15,
								],
							]
						),
						Attribute::create(
							'title',
							[
								'type'         => 'text',
								'title'        => 'Title',
								'inline_label' => true,
							]
						),
						Attribute::create(
							'hide_empty',
							[
								'type'         => 'toggle',
								'title'        => 'Hide when Empty',
								'inline_label' => true,
								'description'  => 'Hide cart icon when its empty.',
							]
						),
						Attribute::create(
							'counter_badge',
							[
								'type'         => 'toggle',
								'title'        => 'Counter Badge',
								'inline_label' => true,
								'default'      => true,
								'description'  => 'Show number of items in cart.',
								'dependency'   => [
									'icon' => [
										'value'   => 'none',
										'compare' => '!=',
									],
								],
							]
						),
						Attribute::create(
							'click_action',
							[
								'type'         => 'select',
								'title'        => 'Click Action',
								'inline_label' => true,
								'choices'      => [
									'cart-page' => 'Go to Cart Page',
									'mini-cart' => 'Show Mini Cart',
								],
								'default'      => 'mini-cart-popup',
							]
						),
					]
				),

				// Content / Popup
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					'Popup',
					[
						Attribute::create(
							'popup_show_on',
							[
								'type'         => 'radio',
								'title'        => 'Show On',
								'inline_label' => true,
								'choices'      => [
									'click' => 'Click',
									'hover' => 'Hover',
								],
								'buttons'      => true,
								'dependency'   => [
									'click_action' => 'mini-cart',
								],
							]
						),
						Attribute::create(
							'popup_align',
							[
								'type'         => 'radio',
								'title'        => 'Alignment',
								'inline_label' => true,
								'choices'      => [
									'left'   => [
										'label' => 'Left',
										'icon'  => 'justifyLeft',
									],
									'center' => [
										'label' => 'Center',
										'icon'  => 'justifyCenter',
									],
									'right'  => [
										'label' => 'Right',
										'icon'  => 'justifyRight',
									],
								],
								'buttons'      => [
									'icon_size' => 18,
								],
								'dependency'   => [
									'click_action' => 'mini-cart',
								],
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		if ( ! function_exists( 'kalium_header_woocommerce_cart' ) ) {
			return;
		}

		kalium_header_woocommerce_cart(
			[
				'icon'          => $this->get_attribute_value( 'icon' ),
				'hide_empty'    => $this->get_attribute_value( 'hide_empty' ),
				'counter_badge' => $this->get_attribute_value( 'counter_badge' ),
				'title'         => $this->get_attribute_value( 'title' ),
				'click_action'  => $this->get_attribute_value( 'click_action' ),
				'popup_show_on' => $this->get_attribute_value( 'popup_show_on' ),
				'popup_align'   => $this->get_attribute_value( 'popup_align' ),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_WooCommerce_Mini_Cart::class );
