<?php
/**
 * My Account Link element.
 */
namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute;

class Legacy_Header_WooCommerce_My_Account_Link extends Legacy_Header_Base_Element {

	/**
	 * Element name.
	 *
	 * @var string
	 * @static
	 */
	public static $name = 'legacy_header_woocommerce_my_account_link';

	/**
	 * Title.
	 *
	 * @var string
	 * @static
	 */
	public static $title = 'My Account';

	/**
	 * Icon.
	 *
	 * @var string
	 * @static
	 */
	public static $icon = 'commentAuthorAvatar';

	/**
	 * Create attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[
				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'login_text',
							[
								'type'         => 'text',
								'title'        => 'Login Text',
								'inline_label' => true,
								'default'      => 'Login or Register',
								'description'  => 'Displayed to guest users.',
							]
						),
						Attribute::create(
							'logged_in_text',
							[
								'type'         => 'text',
								'title'        => 'Logged In Text',
								'inline_label' => true,
								'default'      => 'My Account',
								'description'  => 'Displayed to registered users.',
							]
						),
						Attribute::create(
							'link_icon',
							[
								'type'         => 'toggle',
								'title'        => 'Show Icon',
								'inline_label' => true,
								'default'      => true,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Element content.
	 */
	public function element_content() {
		$login_text     = $this->get_attribute_value( 'login_text' );
		$logged_in_text = $this->get_attribute_value( 'logged_in_text' );
		$link_icon      = $this->get_attribute_value( 'link_icon' );

		if ( kalium()->is->woocommerce_active() ) {
			$content        = $login_text;
			$widget_classes = [
				'woocommerce-account-link',
			];

			// Logged in user
			if ( is_user_logged_in() ) {
				$content = $logged_in_text;
			}

			// With icon
			if ( kalium_validate_boolean( $link_icon ) ) {
				$icon = kalium_get_icon( 'my-account' );

				if ( trim( $content ) ) {
					$content = sprintf( '<span class="woocommerce-account-link__icon">%1$s</span> <span class="woocommerce-account-link__label"><span class="link">%2$s</span></span>', $icon, $content );
				} else {
					$content = sprintf( '<span class="woocommerce-account-link__icon">%1$s</span>', $icon );
				}

				$widget_classes[] = 'woocommerce-my-account-link--has-icon';
			}

			// Display my account link
			kalium_render_element(
				[
					'tag_name'   => 'a',
					'attributes' => [
						'href'       => wc_get_page_permalink( 'myaccount' ),
						'class'      => $widget_classes,
						'aria-label' => 'My Account',
					],
					'content'    => $content,
				]
			);
		}
	}


	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		$has_icon   = $this->get_attribute_value( 'link_icon' );
		$link_style = kalium_if_else( false === $has_icon, kalium_get_link_style_class_by_context( 'header-my-account-link', kalium_get_link_plain_class() ), kalium_get_link_plain_class() );

		return array_merge(
			parent::get_dom_class(),
			[
				$link_style,
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( Legacy_Header_WooCommerce_My_Account_Link::class );
