<?php
/**
 * Product column element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Attribute_Sets\Advanced_Visibility_Hover_Set;
use Laborator_Builder\Attribute_Sets\Product_Common_Attributes_Set;

class WooCommerce_Product_Column extends Column {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_column';

	/**
	 * Allowed child elements.
	 *
	 * @var bool
	 */
	public static $allowed_child_elements = [
		'!woocommerce_product_column',
	];

	/**
	 * Attribute sets.
	 *
	 * @var array
	 */
	public static $attribute_sets = [];

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Visibility_Hover_Set::class,
				Product_Common_Attributes_Set::class,
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Column::class );
