<?php
/**
 * Title element.
 */

namespace Laborator_Builder\Elements;

use Laborator_Builder\Element;
use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Sets\Advanced_Border_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Custom_CSS_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Dimensions_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Layout_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Text_Set;
use Laborator_Builder\Attribute_Sets\Advanced_Visibility_Hover_Set;
use Laborator_Builder\Attribute_Sets\Product_Common_Attributes_Set;

class WooCommerce_Product_Title extends Element {

	/**
	 * Name.
	 *
	 * @var string
	 */
	public static $name = 'woocommerce_product_title';

	/**
	 * Title.
	 *
	 * @var string
	 */
	public static $title = 'Title';

	/**
	 * Icon.
	 *
	 * @var string
	 */
	public static $icon = 'title';

	/**
	 * Maximum instances of element.
	 *
	 * @var int
	 * @static
	 */
	public static $max_instances = 1;

	/**
	 * Get attribute sets.
	 *
	 * @return array
	 */
	public function get_attribute_sets() {
		return array_merge(
			parent::get_attribute_sets(),
			[
				Advanced_Layout_Set::class,
				Advanced_Visibility_Hover_Set::class,
				Advanced_Border_Set::class,
				Advanced_Text_Set::class,
				Advanced_Dimensions_Set::class,
				Advanced_Custom_CSS_Set::class,
				Product_Common_Attributes_Set::class,
			]
		);
	}

	/**
	 * Attributes.
	 *
	 * @return Attribute[]
	 */
	public function create_attributes() {
		return array_merge(
			parent::create_attributes(),
			[

				// Content / Content
				Attribute::tab_section(
					Attribute::TAB_CONTENT,
					Attribute::SECTION_CONTENT,
					[
						Attribute::create(
							'tag_name',
							[
								'type'         => 'select',
								'title'        => 'HTML Tag',
								'inline_label' => true,
								'choices'      => [
									'h1'   => 'H1',
									'h2'   => 'H2',
									'h3'   => 'H3',
									'h4'   => 'H4',
									'span' => 'span',
								],
								'default'      => 'h3',
							]
						),
						Attribute::create(
							'link_to_product',
							[
								'type'         => 'toggle',
								'title'        => 'Link to product',
								'inline_label' => true,
								'default'      => true,
							]
						),
					]
				),
			]
		);
	}

	/**
	 * Init.
	 */
	public function init() {
		parent::init();

		// Custom element tag
		if ( $tag_name = $this->get_attribute_value( 'tag_name' ) ) {
			$this->tag_name = $tag_name;
		}
	}

	/**
	 * Get element class list.
	 *
	 * @return array
	 */
	public function get_dom_class() {
		return array_merge(
			parent::get_dom_class(),
			[
				kalium_get_link_plain_class(),
			]
		);
	}
}

// Register element
\Laborator_Builder::register_element_type( WooCommerce_Product_Title::class );
