<?php
/**
 * Custom CSS attributes.
 */

namespace Laborator_Builder\Attribute_Sets;

use Laborator_Builder\Attribute;
use Laborator_Builder\Attribute_Set;
use Laborator_Builder\Predefined_Attributes;

class Advanced_Custom_CSS_Set extends Attribute_Set {

	/**
	 * Get attributes.
	 *
	 * @return array
	 */
	public function get_attributes() {
		return Attribute::tab_section(
			Attribute::TAB_ADVANCED,
			Attribute::SECTION_CUSTOM_CSS,
			[
				Attribute::create( Predefined_Attributes::$CUSTOM_CSS ),
			]
		);
	}

	/**
	 * Generate styles.
	 */
	public function generate_styles() {
		$element = $this->get_element();

		// Custom CSS
		$element->add_custom_css( 'custom_css', $element->get_attribute( 'custom_css' ) );
	}
}
